/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.table;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fo.flow.table.EffRow;
import org.apache.fop.fo.flow.table.PrimaryGridUnit;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.layoutmgr.ElementListUtils;
import org.apache.fop.layoutmgr.Keep;
import org.apache.fop.layoutmgr.KnuthBlockBox;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.table.CellPart;
import org.apache.fop.layoutmgr.table.TableCellLayoutManager;
import org.apache.fop.layoutmgr.table.TableLayoutManager;
import org.apache.fop.traits.MinOptMax;

class ActiveCell {
    private static Log log = LogFactory.getLog(ActiveCell.class);
    private PrimaryGridUnit pgu;
    private List elementList;
    private ListIterator knuthIter;
    private int endRowIndex;
    private int remainingLength;
    private int totalLength;
    private int includedLength;
    private int paddingBeforeNormal;
    private int paddingBeforeLeading;
    private int paddingAfterNormal;
    private int paddingAfterTrailing;
    private int bpBeforeNormal;
    private int bpBeforeLeading;
    private int bpAfterNormal;
    private int bpAfterTrailing;
    private boolean lastCellPart;
    private Keep keepWithNext;
    private int spanIndex = 0;
    private Step previousStep;
    private Step nextStep;
    private Step afterNextStep;

    static int getElementContentLength(KnuthElement knuthElement) {
        if (knuthElement instanceof FillerPenalty) {
            return ((FillerPenalty)knuthElement).contentLength;
        }
        if (knuthElement instanceof FillerBox) {
            return 0;
        }
        return knuthElement.getWidth();
    }

    ActiveCell(PrimaryGridUnit primaryGridUnit, EffRow effRow, int n, int n2, TableLayoutManager tableLayoutManager) {
        this.pgu = primaryGridUnit;
        CommonBorderPaddingBackground commonBorderPaddingBackground = primaryGridUnit.getCell().getCommonBorderPaddingBackground();
        TableCellLayoutManager tableCellLayoutManager = primaryGridUnit.getCellLM();
        this.paddingBeforeNormal = commonBorderPaddingBackground.getPaddingBefore(false, tableCellLayoutManager);
        this.paddingBeforeLeading = commonBorderPaddingBackground.getPaddingBefore(true, tableCellLayoutManager);
        this.paddingAfterNormal = commonBorderPaddingBackground.getPaddingAfter(false, tableCellLayoutManager);
        this.paddingAfterTrailing = commonBorderPaddingBackground.getPaddingAfter(true, tableCellLayoutManager);
        this.bpBeforeNormal = this.paddingBeforeNormal + primaryGridUnit.getBeforeBorderWidth(0, 0);
        this.bpBeforeLeading = this.paddingBeforeLeading + primaryGridUnit.getBeforeBorderWidth(0, 2);
        this.bpAfterNormal = this.paddingAfterNormal + primaryGridUnit.getAfterBorderWidth(0);
        this.bpAfterTrailing = this.paddingAfterTrailing + primaryGridUnit.getAfterBorderWidth(0, 2);
        this.elementList = primaryGridUnit.getElements();
        this.handleExplicitHeight(primaryGridUnit.getCell().getBlockProgressionDimension().toMinOptMax(tableLayoutManager), effRow.getExplicitHeight());
        this.knuthIter = this.elementList.listIterator();
        this.includedLength = -1;
        this.totalLength = n2 + ElementListUtils.calcContentLength(this.elementList);
        this.endRowIndex = n + primaryGridUnit.getCell().getNumberRowsSpanned() - 1;
        this.keepWithNext = Keep.KEEP_AUTO;
        this.remainingLength = this.totalLength - n2;
        this.afterNextStep = new Step(n2);
        this.previousStep = new Step(this.afterNextStep);
        this.gotoNextLegalBreak();
        this.nextStep = new Step(this.afterNextStep);
        if (this.afterNextStep.end < this.elementList.size() - 1) {
            this.gotoNextLegalBreak();
        }
    }

    private void handleExplicitHeight(MinOptMax minOptMax, MinOptMax minOptMax2) {
        int n = Math.max(minOptMax.getMin(), minOptMax2.getMin());
        if (n > 0) {
            ListIterator<FillerPenalty> listIterator = this.elementList.listIterator();
            int n2 = 0;
            boolean bl = false;
            while (listIterator.hasNext() && n2 < n) {
                KnuthElement knuthElement = (KnuthElement)listIterator.next();
                if (knuthElement.isBox()) {
                    bl = true;
                    n2 += knuthElement.getWidth();
                    continue;
                }
                if (knuthElement.isGlue()) {
                    if (bl) {
                        this.elementList.add(listIterator.nextIndex() - 1, new FillerPenalty(n - n2));
                    }
                    bl = false;
                    n2 += knuthElement.getWidth();
                    continue;
                }
                bl = false;
                if (n2 + knuthElement.getWidth() >= n) continue;
                listIterator.set(new FillerPenalty((KnuthPenalty)knuthElement, n - n2));
            }
        }
        int n3 = Math.max(n, Math.max(minOptMax.getOpt(), minOptMax2.getOpt()));
        if (this.pgu.getContentLength() < n3) {
            this.elementList.add(new FillerBox(n3 - this.pgu.getContentLength()));
        }
    }

    PrimaryGridUnit getPrimaryGridUnit() {
        return this.pgu;
    }

    boolean endsOnRow(int n) {
        return n == this.endRowIndex;
    }

    int getRemainingLength() {
        if (this.includedInLastStep() && this.nextStep.end == this.elementList.size() - 1) {
            return 0;
        }
        return this.bpBeforeLeading + this.remainingLength + this.bpAfterNormal;
    }

    private void gotoNextLegalBreak() {
        this.afterNextStep.penaltyLength = 0;
        this.afterNextStep.penaltyValue = 0;
        this.afterNextStep.condBeforeContentLength = 0;
        this.afterNextStep.breakClass = 9;
        if (this.afterNextStep.footnoteList != null) {
            this.afterNextStep.footnoteList.clear();
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        while (!bl && this.knuthIter.hasNext()) {
            KnuthElement knuthElement = (KnuthElement)this.knuthIter.next();
            if (knuthElement.isPenalty()) {
                bl2 = false;
                if (knuthElement.getPenalty() >= 1000 && ((KnuthPenalty)knuthElement).getBreakClass() != 104) continue;
                bl = true;
                KnuthPenalty knuthPenalty = (KnuthPenalty)knuthElement;
                this.afterNextStep.penaltyLength = knuthPenalty.getWidth();
                this.afterNextStep.penaltyValue = knuthPenalty.getPenalty();
                if (!knuthPenalty.isForcedBreak()) continue;
                this.afterNextStep.breakClass = knuthPenalty.getBreakClass();
                continue;
            }
            if (knuthElement.isGlue()) {
                if (bl2) {
                    bl = true;
                } else {
                    this.afterNextStep.contentLength += knuthElement.getWidth();
                    if (!bl3) {
                        this.afterNextStep.condBeforeContentLength += knuthElement.getWidth();
                    }
                }
                bl2 = false;
                continue;
            }
            if (knuthElement instanceof KnuthBlockBox && ((KnuthBlockBox)knuthElement).hasAnchors()) {
                if (this.afterNextStep.footnoteList == null) {
                    this.afterNextStep.footnoteList = new LinkedList();
                }
                this.afterNextStep.footnoteList.addAll(((KnuthBlockBox)knuthElement).getFootnoteBodyLMs());
            }
            bl2 = true;
            bl3 = true;
            this.afterNextStep.contentLength += knuthElement.getWidth();
        }
        this.afterNextStep.end = this.knuthIter.nextIndex() - 1;
        this.afterNextStep.totalLength = this.bpBeforeNormal + this.afterNextStep.contentLength + this.afterNextStep.penaltyLength + this.bpAfterTrailing;
    }

    int getFirstStep() {
        log.debug((Object)(this + ": min first step = " + this.nextStep.totalLength));
        return this.nextStep.totalLength;
    }

    int getLastStep() {
        assert (this.nextStep.end == this.elementList.size() - 1);
        assert (this.nextStep.contentLength == this.totalLength && this.nextStep.penaltyLength == 0);
        int n = this.bpBeforeNormal + this.totalLength + this.paddingAfterNormal + this.pgu.getAfterBorderWidth(1);
        log.debug((Object)(this + ": last step = " + n));
        return n;
    }

    private void increaseCurrentStep(int n) {
        if (this.nextStep.end < this.elementList.size() - 1) {
            while (this.afterNextStep.totalLength <= n && this.nextStep.breakClass == 9) {
                int n2 = this.nextStep.condBeforeContentLength;
                this.nextStep.set(this.afterNextStep);
                this.nextStep.condBeforeContentLength = n2;
                if (this.afterNextStep.end >= this.elementList.size() - 1) break;
                this.gotoNextLegalBreak();
            }
        }
    }

    void signalRowFirstStep(int n) {
        this.increaseCurrentStep(n);
        if (log.isTraceEnabled()) {
            log.trace((Object)(this + ": first step increased to " + this.nextStep.totalLength));
        }
    }

    void signalRowLastStep(int n) {
        this.increaseCurrentStep(n);
        if (log.isTraceEnabled()) {
            log.trace((Object)(this + ": next step increased to " + this.nextStep.totalLength));
        }
    }

    int getNextStep() {
        if (this.includedInLastStep()) {
            this.previousStep.set(this.nextStep);
            if (this.nextStep.end >= this.elementList.size() - 1) {
                this.nextStep.start = this.elementList.size();
                return -1;
            }
            this.nextStep.set(this.afterNextStep);
            this.nextStep.start = this.previousStep.end + 1;
            this.afterNextStep.start = this.nextStep.start;
            if (this.afterNextStep.end < this.elementList.size() - 1) {
                this.gotoNextLegalBreak();
            }
        }
        return this.nextStep.totalLength;
    }

    private boolean includedInLastStep() {
        return this.includedLength == this.nextStep.contentLength;
    }

    int signalNextStep(int n) {
        if (this.nextStep.totalLength <= n) {
            this.includedLength = this.nextStep.contentLength;
            this.remainingLength = this.totalLength - this.includedLength - this.afterNextStep.condBeforeContentLength;
            return this.nextStep.breakClass;
        }
        return 9;
    }

    void nextRowStarts() {
        ++this.spanIndex;
        this.nextStep.totalLength -= this.bpAfterTrailing;
        this.afterNextStep.totalLength -= this.bpAfterTrailing;
        this.bpAfterTrailing = this.paddingAfterTrailing + this.pgu.getAfterBorderWidth(this.spanIndex, 2);
        this.nextStep.totalLength += this.bpAfterTrailing;
        this.afterNextStep.totalLength += this.bpAfterTrailing;
    }

    void endRow(int n) {
        if (this.endsOnRow(n)) {
            this.nextStep.totalLength -= this.bpAfterTrailing;
            this.bpAfterTrailing = this.paddingAfterNormal + this.pgu.getAfterBorderWidth(1);
            this.nextStep.totalLength += this.bpAfterTrailing;
            this.lastCellPart = true;
        } else {
            this.bpBeforeLeading = this.paddingBeforeLeading + this.pgu.getBeforeBorderWidth(this.spanIndex + 1, 2);
        }
    }

    boolean finishes(int n) {
        return this.nextStep.totalLength <= n && this.nextStep.end == this.elementList.size() - 1;
    }

    CellPart createCellPart() {
        if (this.nextStep.end + 1 == this.elementList.size()) {
            this.keepWithNext = this.pgu.getKeepWithNext();
        }
        int n = this.nextStep.start == 0 ? this.pgu.getBeforeBorderWidth(0, 1) + this.paddingBeforeNormal : this.bpBeforeLeading;
        int n2 = this.nextStep.contentLength - this.nextStep.condBeforeContentLength - this.previousStep.contentLength;
        if (!this.includedInLastStep() || this.nextStep.start == this.elementList.size()) {
            return new CellPart(this.pgu, this.nextStep.start, this.previousStep.end, this.lastCellPart, 0, 0, this.previousStep.penaltyLength, this.bpBeforeNormal, n, this.bpAfterNormal, this.bpAfterTrailing);
        }
        return new CellPart(this.pgu, this.nextStep.start, this.nextStep.end, this.lastCellPart, this.nextStep.condBeforeContentLength, n2, this.nextStep.penaltyLength, this.bpBeforeNormal, n, this.bpAfterNormal, this.bpAfterTrailing);
    }

    void addFootnotes(List list) {
        if (this.includedInLastStep() && this.nextStep.footnoteList != null) {
            list.addAll(this.nextStep.footnoteList);
            this.nextStep.footnoteList.clear();
        }
    }

    Keep getKeepWithNext() {
        return this.keepWithNext;
    }

    int getPenaltyValue() {
        if (this.includedInLastStep()) {
            return this.nextStep.penaltyValue;
        }
        return this.previousStep.penaltyValue;
    }

    public String toString() {
        return "Cell " + (this.pgu.getRowIndex() + 1) + "." + (this.pgu.getColIndex() + 1);
    }

    private static class FillerBox
    extends KnuthBox {
        FillerBox(int n) {
            super(n, null, true);
        }
    }

    private static class FillerPenalty
    extends KnuthPenalty {
        private int contentLength;

        FillerPenalty(KnuthPenalty knuthPenalty, int n) {
            super(n, knuthPenalty.getPenalty(), knuthPenalty.isPenaltyFlagged(), knuthPenalty.getBreakClass(), knuthPenalty.getPosition(), knuthPenalty.isAuxiliary());
            this.contentLength = knuthPenalty.getWidth();
        }

        FillerPenalty(int n) {
            super(n, 0, false, null, true);
            this.contentLength = 0;
        }
    }

    private static class Step {
        private int start;
        private int end;
        private int contentLength;
        private int totalLength;
        private int penaltyLength;
        private int penaltyValue;
        private List footnoteList;
        private int breakClass;
        private int condBeforeContentLength;

        Step(int n) {
            this.contentLength = n;
            this.end = -1;
        }

        Step(Step step) {
            this.set(step);
        }

        void set(Step step) {
            this.start = step.start;
            this.end = step.end;
            this.contentLength = step.contentLength;
            this.totalLength = step.totalLength;
            this.penaltyLength = step.penaltyLength;
            this.penaltyValue = step.penaltyValue;
            if (step.footnoteList != null) {
                if (this.footnoteList == null) {
                    this.footnoteList = new ArrayList();
                }
                this.footnoteList.addAll(step.footnoteList);
            }
            this.condBeforeContentLength = step.condBeforeContentLength;
            this.breakClass = step.breakClass;
        }

        public String toString() {
            return "Step: start=" + this.start + " end=" + this.end + " length=" + this.totalLength;
        }
    }
}

