/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Provider;
import java.security.Security;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFEncryption;
import org.apache.fop.pdf.PDFEncryptionParams;

public final class PDFEncryptionManager {
    private static final Log LOG = LogFactory.getLog(PDFEncryptionManager.class);

    private PDFEncryptionManager() {
    }

    public static boolean isJCEAvailable() {
        try {
            Class.forName("javax.crypto.Cipher");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static boolean checkAvailableAlgorithms() {
        if (!PDFEncryptionManager.isJCEAvailable()) {
            return false;
        }
        Provider[] providerArray = Security.getProviders("Cipher.RC4");
        if (providerArray == null) {
            LOG.warn((Object)"Cipher provider for RC4 not available.");
            return false;
        }
        providerArray = Security.getProviders("MessageDigest.MD5");
        if (providerArray == null) {
            LOG.warn((Object)"MessageDigest provider for MD5 not available.");
            return false;
        }
        return true;
    }

    public static void setupPDFEncryption(PDFEncryptionParams pDFEncryptionParams, PDFDocument pDFDocument) {
        if (pDFDocument == null) {
            throw new NullPointerException("PDF document must not be null");
        }
        if (pDFEncryptionParams != null) {
            if (!PDFEncryptionManager.checkAvailableAlgorithms()) {
                if (PDFEncryptionManager.isJCEAvailable()) {
                    LOG.warn((Object)"PDF encryption has been requested, JCE is available but there's no JCE provider available that provides the necessary algorithms. The PDF won't be encrypted.");
                } else {
                    LOG.warn((Object)"PDF encryption has been requested but JCE is unavailable! The PDF won't be encrypted.");
                }
            }
            pDFDocument.setEncryption(pDFEncryptionParams);
        }
    }

    public static PDFEncryption newInstance(int n, PDFEncryptionParams pDFEncryptionParams, PDFDocument pDFDocument) {
        try {
            Class<?> clazz = Class.forName("org.apache.fop.pdf.PDFEncryptionJCE");
            Method method = clazz.getMethod("make", Integer.TYPE, PDFEncryptionParams.class, PDFDocument.class);
            Object object = method.invoke(null, new Integer(n), pDFEncryptionParams, pDFDocument);
            return (PDFEncryption)object;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (PDFEncryptionManager.checkAvailableAlgorithms()) {
                LOG.warn((Object)"JCE and algorithms available, but the implementation class unavailable. Please do a full rebuild.");
            }
            return null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LOG.error((Object)noSuchMethodException);
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            LOG.error((Object)illegalAccessException);
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            LOG.error((Object)invocationTargetException);
            return null;
        }
    }
}

