/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.fop.pdf.ASCII85Filter;
import org.apache.fop.pdf.ASCIIHexFilter;
import org.apache.fop.pdf.FlateFilter;
import org.apache.fop.pdf.NullFilter;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFFilter;
import org.apache.fop.pdf.PDFName;
import org.apache.fop.pdf.PDFObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFFilterList {
    public static final String DEFAULT_FILTER = "default";
    public static final String CONTENT_FILTER = "content";
    public static final String PRECOMPRESSED_FILTER = "precompressed";
    public static final String IMAGE_FILTER = "image";
    public static final String JPEG_FILTER = "jpeg";
    public static final String TIFF_FILTER = "tiff";
    public static final String FONT_FILTER = "font";
    public static final String METADATA_FILTER = "metadata";
    private List<PDFFilter> filters = new ArrayList<PDFFilter>();
    private boolean ignoreASCIIFilters = false;
    private boolean disableAllFilters = false;

    public PDFFilterList() {
    }

    public PDFFilterList(boolean bl) {
        this.ignoreASCIIFilters = bl;
    }

    public void setDisableAllFilters(boolean bl) {
        this.disableAllFilters = bl;
    }

    public boolean isDisableAllFilters() {
        return this.disableAllFilters;
    }

    public boolean isInitialized() {
        return this.filters.size() > 0;
    }

    public void addFilter(PDFFilter pDFFilter) {
        if (pDFFilter != null) {
            if (this.ignoreASCIIFilters && pDFFilter.isASCIIFilter()) {
                return;
            }
            this.filters.add(pDFFilter);
        }
    }

    public void addFilter(String string) {
        if (string == null) {
            return;
        }
        if (string.equals("flate")) {
            this.addFilter(new FlateFilter());
        } else if (string.equals("null")) {
            this.addFilter(new NullFilter());
        } else if (string.equals("ascii-85")) {
            if (this.ignoreASCIIFilters) {
                return;
            }
            this.addFilter(new ASCII85Filter());
        } else if (string.equals("ascii-hex")) {
            if (this.ignoreASCIIFilters) {
                return;
            }
            this.addFilter(new ASCIIHexFilter());
        } else {
            if (string.equals("")) {
                return;
            }
            throw new IllegalArgumentException("Unsupported filter type in stream-filter-list: " + string);
        }
    }

    public void ensureFilterInPlace(PDFFilter pDFFilter) {
        if (this.filters.size() == 0) {
            this.addFilter(pDFFilter);
        } else if (!this.filters.get(0).equals(pDFFilter)) {
            this.filters.add(0, pDFFilter);
        }
    }

    public void addDefaultFilters(Map map, String string) {
        if (METADATA_FILTER.equals(string)) {
            this.addFilter(new NullFilter());
            return;
        }
        List list = null;
        if (map != null && (list = (List)map.get(string)) == null) {
            list = (List)map.get(DEFAULT_FILTER);
        }
        if (list == null || list.size() == 0) {
            if (JPEG_FILTER.equals(string)) {
                this.addFilter(new NullFilter());
            } else if (TIFF_FILTER.equals(string)) {
                this.addFilter(new NullFilter());
            } else if (PRECOMPRESSED_FILTER.equals(string)) {
                this.addFilter(new NullFilter());
            } else {
                this.addFilter(new FlateFilter());
            }
        } else {
            for (int i = 0; i < list.size(); ++i) {
                String string2 = (String)list.get(i);
                this.addFilter(string2);
            }
        }
    }

    List<PDFFilter> getFilters() {
        return Collections.unmodifiableList(this.filters);
    }

    protected String buildFilterDictEntries() {
        if (this.filters.size() > 0) {
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            int n = this.populateNamesAndParms(arrayList, arrayList2);
            return this.buildFilterEntries(arrayList) + (n > 0 ? this.buildDecodeParms(arrayList2) : "");
        }
        return "";
    }

    protected void putFilterDictEntries(PDFDictionary pDFDictionary) {
        if (this.filters.size() > 0) {
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            this.populateNamesAndParms(arrayList, arrayList2);
            this.putFilterEntries(pDFDictionary, arrayList);
            this.putDecodeParams(pDFDictionary, arrayList2);
        }
    }

    private int populateNamesAndParms(List list, List list2) {
        int n = 0;
        for (int i = 0; i < this.filters.size(); ++i) {
            PDFFilter pDFFilter = this.filters.get(i);
            if (pDFFilter.getName().length() <= 0) continue;
            list.add(0, pDFFilter.getName());
            PDFObject pDFObject = pDFFilter.getDecodeParms();
            if (pDFObject != null) {
                list2.add(0, pDFObject);
                ++n;
                continue;
            }
            list2.add(0, null);
        }
        return n;
    }

    private String buildFilterEntries(List list) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer(64);
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            if (string.length() <= 0) continue;
            ++n;
            stringBuffer.append(string);
            stringBuffer.append(" ");
        }
        if (n > 0) {
            if (n > 1) {
                return "/Filter [ " + stringBuffer.toString() + "]";
            }
            return "/Filter " + stringBuffer.toString();
        }
        return "";
    }

    private void putFilterEntries(PDFDictionary pDFDictionary, List list) {
        PDFArray pDFArray = new PDFArray(pDFDictionary);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            String string = (String)list.get(i);
            if (string.length() <= 0) continue;
            pDFArray.add(new PDFName(string));
        }
        if (pDFArray.length() > 0) {
            if (pDFArray.length() > 1) {
                pDFDictionary.put("Filter", pDFArray);
            } else {
                pDFDictionary.put("Filter", pDFArray.get(0));
            }
        }
    }

    private String buildDecodeParms(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        stringBuffer.append("\n/DecodeParms ");
        if (list.size() > 1) {
            stringBuffer.append("[ ");
        }
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            if (string != null) {
                stringBuffer.append(string);
                bl = true;
            } else {
                stringBuffer.append("null");
            }
            stringBuffer.append(" ");
        }
        if (list.size() > 1) {
            stringBuffer.append("]");
        }
        if (bl) {
            return stringBuffer.toString();
        }
        return "";
    }

    private void putDecodeParams(PDFDictionary pDFDictionary, List list) {
        boolean bl = false;
        PDFArray pDFArray = new PDFArray(pDFDictionary);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Object e = list.get(i);
            if (e != null) {
                pDFArray.add(e);
                bl = true;
                continue;
            }
            pDFArray.add(null);
        }
        if (pDFArray.length() > 0 & bl) {
            if (pDFArray.length() > 1) {
                pDFDictionary.put("DecodeParms", pDFArray);
            } else {
                pDFDictionary.put("DecodeParms", pDFArray.get(0));
            }
        }
    }

    public OutputStream applyFilters(OutputStream outputStream) throws IOException {
        OutputStream outputStream2 = outputStream;
        if (!this.isDisableAllFilters()) {
            for (int i = this.filters.size() - 1; i >= 0; --i) {
                PDFFilter pDFFilter = this.filters.get(i);
                outputStream2 = pDFFilter.applyFilter(outputStream2);
            }
        }
        return outputStream2;
    }
}

