/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.util.HashMap;
import java.util.Map;
import org.apache.fop.pdf.PDFObject;

public class PDFGState
extends PDFObject {
    public static final String GSTATE_LINE_WIDTH = "LW";
    public static final String GSTATE_LINE_CAP = "LC";
    public static final String GSTATE_LINE_JOIN = "LJ";
    public static final String GSTATE_MITER_LIMIT = "ML";
    public static final String GSTATE_DASH_PATTERN = "D";
    public static final String GSTATE_RENDERING_INTENT = "RI";
    public static final String GSTATE_OVERPRINT_STROKE = "OP";
    public static final String GSTATE_OVERPRINT_FILL = "op";
    public static final String GSTATE_OVERPRINT_MODE = "OPM";
    public static final String GSTATE_FONT = "Font";
    public static final String GSTATE_BLACK_GENERATION = "BG";
    public static final String GSTATE_BLACK_GENERATION2 = "BG2";
    public static final String GSTATE_UNDERCOLOR_REMOVAL = "UCR";
    public static final String GSTATE_UNDERCOLOR_REMOVAL2 = "UCR2";
    public static final String GSTATE_TRANSFER_FUNCTION = "TR";
    public static final String GSTATE_TRANSFER_FUNCTION2 = "TR2";
    public static final String GSTATE_HALFTONE_DICT = "HT";
    public static final String GSTATE_HALFTONE_PHASE = "HTP";
    public static final String GSTATE_FLATNESS = "FL";
    public static final String GSTATE_SMOOTHNESS = "SM";
    public static final String GSTATE_STRIKE_ADJ = "SA";
    public static final String GSTATE_BLEND_MODE = "BM";
    public static final String GSTATE_SOFT_MASK = "SMask";
    public static final String GSTATE_ALPHA_STROKE = "CA";
    public static final String GSTATE_ALPHA_NONSTROKE = "ca";
    public static final String GSTATE_ALPHA_SOURCE_FLAG = "AIS";
    public static final String GSTATE_TEXT_KNOCKOUT = "TK";
    public static final PDFGState DEFAULT = new PDFGState();
    private Map values = new HashMap();

    public String getName() {
        return "GS" + this.getObjectNumber();
    }

    public void setAlpha(float f, boolean bl) {
        if (bl) {
            this.values.put(GSTATE_ALPHA_NONSTROKE, new Float(f));
        } else {
            this.values.put(GSTATE_ALPHA_STROKE, new Float(f));
        }
    }

    public void addValues(PDFGState pDFGState) {
        this.values.putAll(pDFGState.values);
    }

    public void addValues(Map map) {
        this.values.putAll(map);
    }

    public String toPDFString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("<<\n/Type /ExtGState\n");
        this.appendVal(stringBuffer, GSTATE_ALPHA_NONSTROKE);
        this.appendVal(stringBuffer, GSTATE_ALPHA_STROKE);
        stringBuffer.append(">>");
        return stringBuffer.toString();
    }

    private void appendVal(StringBuffer stringBuffer, String string) {
        Object v = this.values.get(string);
        if (v != null) {
            stringBuffer.append("/" + string + " " + v + "\n");
        }
    }

    protected boolean contentEquals(PDFObject pDFObject) {
        if (pDFObject == this) {
            return true;
        }
        if (!(pDFObject instanceof PDFGState)) {
            return false;
        }
        Map map = this.values;
        Map map2 = ((PDFGState)pDFObject).values;
        if (map.size() != map2.size()) {
            return false;
        }
        for (Object k : map.keySet()) {
            Object v = map.get(k);
            if (v.equals(map2.get(k))) continue;
            return false;
        }
        return true;
    }

    static {
        Map map = PDFGState.DEFAULT.values;
        map.put(GSTATE_ALPHA_STROKE, new Float(1.0));
        map.put(GSTATE_ALPHA_NONSTROKE, new Float(1.0));
    }
}

