/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.fop.pdf.PDFICCStream;
import org.apache.fop.pdf.PDFObject;

public class PDFOutputIntent
extends PDFObject {
    public static final String GTS_PDFX = "GTS_PDFX";
    public static final String GTS_PDFA1 = "GTS_PDFA1";
    private String subtype;
    private String outputCondition;
    private String outputConditionIdentifier;
    private String registryName;
    private String info;
    private PDFICCStream destOutputProfile;

    public String getSubtype() {
        return this.subtype;
    }

    public void setSubtype(String string) {
        this.subtype = string;
    }

    public String getOutputCondition() {
        return this.outputCondition;
    }

    public void setOutputCondition(String string) {
        this.outputCondition = string;
    }

    public String getOutputConditionIdentifier() {
        return this.outputConditionIdentifier;
    }

    public void setOutputConditionIdentifier(String string) {
        this.outputConditionIdentifier = string;
    }

    public String getRegistryName() {
        return this.registryName;
    }

    public void setRegistryName(String string) {
        this.registryName = string;
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String string) {
        this.info = string;
    }

    public PDFICCStream getDestOutputProfile() {
        return this.destOutputProfile;
    }

    public void setDestOutputProfile(PDFICCStream pDFICCStream) {
        this.destOutputProfile = pDFICCStream;
    }

    public byte[] toPDF() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(128);
        try {
            byteArrayOutputStream.write(PDFOutputIntent.encode("<<\n"));
            byteArrayOutputStream.write(PDFOutputIntent.encode("/Type /OutputIntent\n"));
            byteArrayOutputStream.write(PDFOutputIntent.encode("/S /"));
            byteArrayOutputStream.write(PDFOutputIntent.encode(this.subtype));
            byteArrayOutputStream.write(PDFOutputIntent.encode("\n"));
            if (this.outputCondition != null) {
                byteArrayOutputStream.write(PDFOutputIntent.encode("/OutputCondition "));
                byteArrayOutputStream.write(this.encodeText(this.outputCondition));
                byteArrayOutputStream.write(PDFOutputIntent.encode("\n"));
            }
            byteArrayOutputStream.write(PDFOutputIntent.encode("/OutputConditionIdentifier "));
            byteArrayOutputStream.write(this.encodeText(this.outputConditionIdentifier));
            byteArrayOutputStream.write(PDFOutputIntent.encode("\n"));
            if (this.registryName != null) {
                byteArrayOutputStream.write(PDFOutputIntent.encode("/RegistryName "));
                byteArrayOutputStream.write(this.encodeText(this.registryName));
                byteArrayOutputStream.write(PDFOutputIntent.encode("\n"));
            }
            if (this.info != null) {
                byteArrayOutputStream.write(PDFOutputIntent.encode("/Info "));
                byteArrayOutputStream.write(this.encodeText(this.info));
                byteArrayOutputStream.write(PDFOutputIntent.encode("\n"));
            }
            if (this.destOutputProfile != null) {
                byteArrayOutputStream.write(PDFOutputIntent.encode("/DestOutputProfile " + this.destOutputProfile.referencePDF() + "\n"));
            }
            byteArrayOutputStream.write(PDFOutputIntent.encode(">>"));
        }
        catch (IOException iOException) {
            log.error((Object)"Ignored I/O exception", (Throwable)iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

