/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.awt.geom.Rectangle2D;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFName;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFPages;
import org.apache.fop.pdf.PDFReference;
import org.apache.fop.pdf.PDFResourceContext;
import org.apache.fop.pdf.PDFResources;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.pdf.TransitionDictionary;

public class PDFPage
extends PDFResourceContext {
    protected int pageIndex;

    public PDFPage(PDFResources pDFResources, int n, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, Rectangle2D rectangle2D3, Rectangle2D rectangle2D4) {
        super(pDFResources);
        this.put("Type", new PDFName("Page"));
        this.setSimplePageSize(rectangle2D, rectangle2D2, rectangle2D3, rectangle2D4);
        this.pageIndex = n;
    }

    private void setSimplePageSize(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, Rectangle2D rectangle2D3, Rectangle2D rectangle2D4) {
        this.setMediaBox(rectangle2D);
        if (rectangle2D2 == null) {
            rectangle2D2 = rectangle2D;
        }
        this.setCropBox(rectangle2D2);
        if (rectangle2D3 == null) {
            rectangle2D3 = rectangle2D2;
        }
        this.setBleedBox(rectangle2D3);
        if (rectangle2D4 == null) {
            rectangle2D4 = rectangle2D3;
        }
        this.setTrimBox(rectangle2D4);
    }

    private PDFArray toPDFArray(Rectangle2D rectangle2D) {
        return new PDFArray((PDFObject)this, new double[]{rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getMaxX(), rectangle2D.getMaxY()});
    }

    public void setMediaBox(Rectangle2D rectangle2D) {
        this.put("MediaBox", this.toPDFArray(rectangle2D));
    }

    public void setCropBox(Rectangle2D rectangle2D) {
        this.put("CropBox", this.toPDFArray(rectangle2D));
    }

    public void setBleedBox(Rectangle2D rectangle2D) {
        this.put("BleedBox", this.toPDFArray(rectangle2D));
    }

    public void setTrimBox(Rectangle2D rectangle2D) {
        this.put("TrimBox", this.toPDFArray(rectangle2D));
    }

    public void setContents(PDFStream pDFStream) {
        if (pDFStream != null) {
            this.put("Contents", new PDFReference(pDFStream));
        }
    }

    public void setParent(PDFPages pDFPages) {
        this.put("Parent", new PDFReference(pDFPages));
    }

    public void setTransition(int n, TransitionDictionary transitionDictionary) {
        this.put("Dur", new Integer(n));
        this.put("Trans", transitionDictionary);
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public void setStructParents(int n) {
        this.put("StructParents", n);
        this.setTabs(new PDFName("S"));
    }

    public Integer getStructParents() {
        return (Integer)this.get("StructParents");
    }

    public void setTabs(PDFName pDFName) {
        this.put("Tabs", pDFName);
    }
}

