/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import org.apache.fop.pdf.InMemoryStreamCache;
import org.apache.fop.pdf.StreamCache;
import org.apache.fop.pdf.TempFileStreamCache;

public class StreamCacheFactory {
    private static boolean defaultCacheToFile = false;
    private static StreamCacheFactory fileInstance = null;
    private static StreamCacheFactory memoryInstance = null;
    private boolean cacheToFile = false;

    public static StreamCacheFactory getInstance(boolean bl) {
        if (bl) {
            if (fileInstance == null) {
                fileInstance = new StreamCacheFactory(true);
            }
            return fileInstance;
        }
        if (memoryInstance == null) {
            memoryInstance = new StreamCacheFactory(false);
        }
        return memoryInstance;
    }

    public static StreamCacheFactory getInstance() {
        return StreamCacheFactory.getInstance(defaultCacheToFile);
    }

    public static void setDefaultCacheToFile(boolean bl) {
        defaultCacheToFile = bl;
    }

    public StreamCacheFactory(boolean bl) {
        this.cacheToFile = bl;
    }

    public StreamCache createStreamCache() throws IOException {
        if (this.cacheToFile) {
            return new TempFileStreamCache();
        }
        return new InMemoryStreamCache();
    }

    public StreamCache createStreamCache(int n) throws IOException {
        if (this.cacheToFile) {
            return new TempFileStreamCache();
        }
        return new InMemoryStreamCache(n);
    }

    public boolean getCacheToFile() {
        return this.cacheToFile;
    }
}

