/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render;

import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.events.EventBroadcaster;
import org.apache.fop.image.loader.batik.BatikUtil;
import org.apache.fop.image.loader.batik.Graphics2DImagePainterImpl;
import org.apache.fop.render.Graphics2DAdapter;
import org.apache.fop.render.RendererContext;
import org.apache.fop.render.RendererContextConstants;
import org.apache.fop.render.XMLHandler;
import org.apache.fop.svg.SVGEventProducer;
import org.apache.fop.svg.SVGUserAgent;
import org.apache.xmlgraphics.java2d.Graphics2DImagePainter;
import org.w3c.dom.Document;

public abstract class AbstractGenericSVGHandler
implements XMLHandler,
RendererContextConstants {
    public void handleXML(RendererContext rendererContext, Document document, String string) throws Exception {
        if ("http://www.w3.org/2000/svg".equals(string)) {
            this.renderSVGDocument(rendererContext, document);
        }
    }

    protected Graphics2DImagePainter createGraphics2DImagePainter(GraphicsNode graphicsNode, BridgeContext bridgeContext, Dimension dimension) {
        return new Graphics2DImagePainterImpl(graphicsNode, bridgeContext, dimension);
    }

    protected GraphicsNode buildGraphicsNode(FOUserAgent fOUserAgent, BridgeContext bridgeContext, Document document) {
        GraphicsNode graphicsNode;
        GVTBuilder gVTBuilder = new GVTBuilder();
        try {
            graphicsNode = gVTBuilder.build(bridgeContext, document);
        }
        catch (Exception exception) {
            EventBroadcaster eventBroadcaster = fOUserAgent.getEventBroadcaster();
            SVGEventProducer sVGEventProducer = SVGEventProducer.Provider.get(eventBroadcaster);
            String string = this.getDocumentURI(document);
            sVGEventProducer.svgNotBuilt(this, exception, string);
            return null;
        }
        return graphicsNode;
    }

    protected Dimension getImageSize(RendererContext.RendererContextWrapper rendererContextWrapper) {
        int n = rendererContextWrapper.getWidth();
        int n2 = rendererContextWrapper.getHeight();
        return new Dimension(n, n2);
    }

    protected void renderSVGDocument(RendererContext rendererContext, Document document) throws IOException {
        this.updateRendererContext(rendererContext);
        FOUserAgent fOUserAgent = rendererContext.getUserAgent();
        SVGUserAgent sVGUserAgent = new SVGUserAgent(fOUserAgent, new AffineTransform());
        BridgeContext bridgeContext = new BridgeContext((UserAgent)sVGUserAgent);
        Document document2 = BatikUtil.cloneSVGDocument(document);
        GraphicsNode graphicsNode = this.buildGraphicsNode(fOUserAgent, bridgeContext, document2);
        RendererContext.RendererContextWrapper rendererContextWrapper = RendererContext.wrapRendererContext(rendererContext);
        Dimension dimension = this.getImageSize(rendererContextWrapper);
        Graphics2DImagePainter graphics2DImagePainter = this.createGraphics2DImagePainter(graphicsNode, bridgeContext, dimension);
        Graphics2DAdapter graphics2DAdapter = rendererContext.getRenderer().getGraphics2DAdapter();
        int n = rendererContextWrapper.getCurrentXPosition();
        int n2 = rendererContextWrapper.getCurrentYPosition();
        int n3 = rendererContextWrapper.getWidth();
        int n4 = rendererContextWrapper.getHeight();
        graphics2DAdapter.paintImage(graphics2DImagePainter, rendererContext, n, n2, n3, n4);
    }

    protected String getDocumentURI(Document document) {
        String string = null;
        if (document instanceof AbstractDocument) {
            AbstractDocument abstractDocument = (AbstractDocument)document;
            string = abstractDocument.getDocumentURI();
        }
        return string;
    }

    protected void updateRendererContext(RendererContext rendererContext) {
    }

    public String getNamespace() {
        return "http://www.w3.org/2000/svg";
    }
}

