/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp;

import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import org.apache.fop.afp.AFPGraphics2D;
import org.apache.fop.afp.AFPGraphicsObjectInfo;
import org.apache.fop.afp.AFPPaintingState;
import org.apache.fop.afp.AFPResourceManager;
import org.apache.fop.render.AbstractGraphics2DAdapter;
import org.apache.fop.render.RendererContext;
import org.apache.fop.render.afp.AFPInfo;
import org.apache.fop.render.afp.AFPRendererContext;
import org.apache.xmlgraphics.java2d.Graphics2DImagePainter;

public class AFPGraphics2DAdapter
extends AbstractGraphics2DAdapter {
    private final AFPPaintingState paintingState;

    public AFPGraphics2DAdapter(AFPPaintingState aFPPaintingState) {
        this.paintingState = aFPPaintingState;
    }

    public void paintImage(Graphics2DImagePainter graphics2DImagePainter, RendererContext rendererContext, int n, int n2, int n3, int n4) throws IOException {
        AFPRendererContext aFPRendererContext = (AFPRendererContext)rendererContext;
        AFPInfo aFPInfo = aFPRendererContext.getInfo();
        AFPGraphics2D aFPGraphics2D = aFPInfo.createGraphics2D(false);
        this.paintingState.save();
        if (aFPInfo.paintAsBitmap()) {
            RendererContext.RendererContextWrapper rendererContextWrapper = RendererContext.wrapRendererContext(rendererContext);
            float f = rendererContext.getUserAgent().getTargetResolution();
            int n5 = Math.round(f);
            boolean bl = aFPInfo.isColorSupported();
            BufferedImage bufferedImage = this.paintToBufferedImage(graphics2DImagePainter, rendererContextWrapper, n5, !bl, false);
            AffineTransform affineTransform = this.paintingState.getData().getTransform();
            affineTransform.translate(n, n2);
            aFPGraphics2D.drawImage(bufferedImage, affineTransform, null);
        } else {
            AFPGraphicsObjectInfo aFPGraphicsObjectInfo = new AFPGraphicsObjectInfo();
            aFPGraphicsObjectInfo.setPainter(graphics2DImagePainter);
            aFPGraphicsObjectInfo.setGraphics2D(aFPGraphics2D);
            Dimension dimension = graphics2DImagePainter.getImageSize();
            float f = (float)dimension.getWidth() / 1000.0f;
            float f2 = (float)dimension.getHeight() / 1000.0f;
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, f, f2);
            aFPGraphicsObjectInfo.setArea(double_);
            AFPResourceManager aFPResourceManager = aFPInfo.getResourceManager();
            aFPResourceManager.createObject(aFPGraphicsObjectInfo);
        }
        this.paintingState.restore();
    }

    protected int mpt2px(int n, int n2) {
        return Math.round(this.paintingState.getUnitConverter().mpt2units(n));
    }
}

