/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp;

import java.awt.Rectangle;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.afp.AFPDataObjectInfo;
import org.apache.fop.afp.AFPImageObjectInfo;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.afp.AFPImageHandlerRawJPEG;
import org.apache.fop.render.afp.AFPRenderingContext;
import org.apache.fop.render.afp.AbstractAFPImageHandlerRawStream;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.impl.ImageRawCCITTFax;
import org.apache.xmlgraphics.image.loader.impl.ImageRawStream;

public class AFPImageHandlerRawCCITTFax
extends AbstractAFPImageHandlerRawStream {
    private static final ImageFlavor[] FLAVORS = new ImageFlavor[]{ImageFlavor.RAW_CCITTFAX};
    private final Log log = LogFactory.getLog(AFPImageHandlerRawJPEG.class);

    protected void setAdditionalParameters(AFPDataObjectInfo aFPDataObjectInfo, ImageRawStream imageRawStream) {
        AFPImageObjectInfo aFPImageObjectInfo = (AFPImageObjectInfo)aFPDataObjectInfo;
        ImageRawCCITTFax imageRawCCITTFax = (ImageRawCCITTFax)imageRawStream;
        int n = imageRawCCITTFax.getCompression();
        aFPImageObjectInfo.setCompression(n);
        aFPImageObjectInfo.setBitsPerPixel(1);
        aFPImageObjectInfo.setMimeType("image/tiff");
    }

    public void handleImage(RenderingContext renderingContext, Image image, Rectangle rectangle) throws IOException {
        this.log.debug((Object)"Embedding undecoded CCITT data as data container...");
        super.handleImage(renderingContext, image, rectangle);
    }

    protected AFPDataObjectInfo createDataObjectInfo() {
        return new AFPImageObjectInfo();
    }

    public int getPriority() {
        return 400;
    }

    public Class getSupportedImageClass() {
        return ImageRawCCITTFax.class;
    }

    public ImageFlavor[] getSupportedImageFlavors() {
        return FLAVORS;
    }

    public boolean isCompatible(RenderingContext renderingContext, Image image) {
        if (renderingContext instanceof AFPRenderingContext) {
            AFPRenderingContext aFPRenderingContext = (AFPRenderingContext)renderingContext;
            return aFPRenderingContext.getPaintingState().isNativeImagesSupported() && (image == null || image instanceof ImageRawCCITTFax);
        }
        return false;
    }
}

