/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.bitmap;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.render.bitmap.BitmapRendererEventProducer;
import org.apache.fop.render.bitmap.BitmapRenderingSettings;
import org.apache.fop.render.bitmap.MultiFileRenderingUtil;
import org.apache.fop.render.intermediate.AbstractBinaryWritingIFDocumentHandler;
import org.apache.fop.render.intermediate.IFContext;
import org.apache.fop.render.intermediate.IFDocumentHandlerConfigurator;
import org.apache.fop.render.intermediate.IFException;
import org.apache.fop.render.intermediate.IFPainter;
import org.apache.fop.render.java2d.Java2DPainter;
import org.apache.fop.render.java2d.Java2DUtil;
import org.apache.xmlgraphics.image.writer.ImageWriter;
import org.apache.xmlgraphics.image.writer.ImageWriterRegistry;
import org.apache.xmlgraphics.image.writer.MultiImageWriter;

public abstract class AbstractBitmapDocumentHandler
extends AbstractBinaryWritingIFDocumentHandler {
    private static Log log = LogFactory.getLog(AbstractBitmapDocumentHandler.class);
    public static final String TARGET_BITMAP_SIZE = "target-bitmap-size";
    private ImageWriter imageWriter;
    private MultiImageWriter multiImageWriter;
    private MultiFileRenderingUtil multiFileUtil;
    private int pageCount;
    private Dimension currentPageDimensions;
    private BufferedImage currentImage;
    private BitmapRenderingSettings bitmapSettings = new BitmapRenderingSettings();
    private double scaleFactor = 1.0;
    private Dimension targetBitmapSize;

    public boolean supportsPagesOutOfOrder() {
        return false;
    }

    public abstract String getMimeType();

    public abstract String getDefaultExtension();

    public void setContext(IFContext iFContext) {
        super.setContext(iFContext);
        int n = Math.round(iFContext.getUserAgent().getTargetResolution());
        this.getSettings().getWriterParams().setResolution(n);
        Map map = this.getUserAgent().getRendererOptions();
        this.setTargetBitmapSize((Dimension)map.get(TARGET_BITMAP_SIZE));
    }

    public abstract IFDocumentHandlerConfigurator getConfigurator();

    public BitmapRenderingSettings getSettings() {
        return this.bitmapSettings;
    }

    public void setDefaultFontInfo(FontInfo fontInfo) {
        FontInfo fontInfo2 = Java2DUtil.buildDefaultJava2DBasedFontInfo(fontInfo, this.getUserAgent());
        this.setFontInfo(fontInfo2);
    }

    public void setTargetBitmapSize(Dimension dimension) {
        this.targetBitmapSize = dimension;
    }

    public void startDocument() throws IFException {
        super.startDocument();
        try {
            this.imageWriter = ImageWriterRegistry.getInstance().getWriterFor(this.getMimeType());
            if (this.imageWriter == null) {
                BitmapRendererEventProducer bitmapRendererEventProducer = BitmapRendererEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
                bitmapRendererEventProducer.noImageWriterFound(this, this.getMimeType());
            }
            if (this.imageWriter.supportsMultiImageWriter()) {
                this.multiImageWriter = this.imageWriter.createMultiImageWriter(this.outputStream);
            } else {
                this.multiFileUtil = new MultiFileRenderingUtil(this.getDefaultExtension(), this.getUserAgent().getOutputFile());
            }
            this.pageCount = 0;
        }
        catch (IOException iOException) {
            throw new IFException("I/O error in startDocument()", iOException);
        }
    }

    public void endDocumentHeader() throws IFException {
    }

    public void endDocument() throws IFException {
        try {
            if (this.multiImageWriter != null) {
                this.multiImageWriter.close();
            }
            this.multiImageWriter = null;
            this.imageWriter = null;
        }
        catch (IOException iOException) {
            throw new IFException("I/O error in endDocument()", iOException);
        }
        super.endDocument();
    }

    public void startPageSequence(String string) throws IFException {
    }

    public void endPageSequence() throws IFException {
    }

    public void startPage(int n, String string, String string2, Dimension dimension) throws IFException {
        ++this.pageCount;
        this.currentPageDimensions = new Dimension(dimension);
    }

    public IFPainter startPageContent() throws IFException {
        double d;
        int n;
        int n2;
        Point2D.Double double_ = null;
        if (this.targetBitmapSize != null) {
            double d2 = (double)(1000 * this.targetBitmapSize.width) / this.currentPageDimensions.getWidth();
            double d3 = (double)(1000 * this.targetBitmapSize.height) / this.currentPageDimensions.getHeight();
            n2 = this.targetBitmapSize.width;
            n = this.targetBitmapSize.height;
            double_ = new Point2D.Double();
            if (d2 < d3) {
                d = d2;
                double d4 = (double)this.currentPageDimensions.height * d / 1000.0;
                ((Point2D)double_).setLocation(0.0, ((double)n - d4) / 2.0);
            } else {
                d = d3;
                double d5 = (double)this.currentPageDimensions.width * d / 1000.0;
                ((Point2D)double_).setLocation(((double)n2 - d5) / 2.0, 0.0);
            }
        } else {
            d = this.scaleFactor * (double)this.getUserAgent().getTargetResolution() / 72.0;
            n2 = (int)((double)this.currentPageDimensions.width * d / 1000.0 + 0.5);
            n = (int)((double)this.currentPageDimensions.height * d / 1000.0 + 0.5);
        }
        this.currentImage = this.createBufferedImage(n2, n);
        Graphics2D graphics2D = this.currentImage.createGraphics();
        if (!this.getSettings().hasTransparentPageBackground()) {
            graphics2D.setBackground(this.getSettings().getPageBackgroundColor());
            graphics2D.setPaint(this.getSettings().getPageBackgroundColor());
            graphics2D.fillRect(0, 0, n2, n);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        if (this.getSettings().isAntiAliasingEnabled() && this.currentImage.getColorModel().getPixelSize() > 1) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        if (this.getSettings().isQualityRenderingEnabled()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        if (double_ != null) {
            graphics2D.translate(((Point2D)double_).getX(), ((Point2D)double_).getY());
        }
        graphics2D.scale(d / 1000.0, d / 1000.0);
        return new Java2DPainter(graphics2D, this.getContext(), this.getFontInfo());
    }

    protected BufferedImage createBufferedImage(int n, int n2) {
        return new BufferedImage(n, n2, this.getSettings().getBufferedImageType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endPageContent() throws IFException {
        try {
            if (this.multiImageWriter == null) {
                switch (this.pageCount) {
                    case 1: {
                        this.imageWriter.writeImage((RenderedImage)this.currentImage, this.outputStream, this.getSettings().getWriterParams());
                        IOUtils.closeQuietly((OutputStream)this.outputStream);
                        this.outputStream = null;
                        break;
                    }
                    default: {
                        OutputStream outputStream = this.multiFileUtil.createOutputStream(this.pageCount - 1);
                        if (outputStream == null) {
                            BitmapRendererEventProducer bitmapRendererEventProducer = BitmapRendererEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
                            bitmapRendererEventProducer.stoppingAfterFirstPageNoFilename(this);
                            break;
                        }
                        try {
                            this.imageWriter.writeImage((RenderedImage)this.currentImage, outputStream, this.getSettings().getWriterParams());
                            break;
                        }
                        finally {
                            IOUtils.closeQuietly((OutputStream)outputStream);
                        }
                    }
                }
            } else {
                this.multiImageWriter.writeImage((RenderedImage)this.currentImage, this.getSettings().getWriterParams());
            }
            this.currentImage = null;
        }
        catch (IOException iOException) {
            throw new IFException("I/O error while encoding BufferedImage", iOException);
        }
    }

    public void endPage() throws IFException {
        this.currentPageDimensions = null;
    }

    public void handleExtensionObject(Object object) throws IFException {
        log.debug((Object)("Don't know how to handle extension object. Ignoring: " + object + " (" + object.getClass().getName() + ")"));
    }
}

