/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.extensions.prepress;

import java.awt.geom.Point2D;
import java.text.MessageFormat;
import java.util.regex.Pattern;
import org.apache.xmlgraphics.util.QName;

public final class PageScale {
    public static final QName EXT_PAGE_SCALE = new QName("http://xmlgraphics.apache.org/fop/extensions", null, "scale");
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s+");

    private PageScale() {
    }

    public static Point2D getScale(String string) {
        double d;
        double d2;
        if (string == null || string.equals("")) {
            return null;
        }
        String[] stringArray = WHITESPACE_PATTERN.split(string);
        try {
            d2 = Double.parseDouble(stringArray[0]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(MessageFormat.format("Extension 'scale' attribute has incorrect value(s): {0}", string));
        }
        switch (stringArray.length) {
            case 1: {
                d = d2;
                break;
            }
            case 2: {
                try {
                    d = Double.parseDouble(stringArray[1]);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException(MessageFormat.format("Extension 'scale' attribute has incorrect value(s): {0}", string));
                }
            }
            default: {
                throw new IllegalArgumentException("Too many arguments");
            }
        }
        if (d2 <= 0.0 || d <= 0.0) {
            throw new IllegalArgumentException(MessageFormat.format("Extension 'scale' attribute has incorrect value(s): {0}", string));
        }
        return new Point2D.Double(d2, d);
    }
}

