/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.intermediate;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.fop.accessibility.StructureTree2SAXEventAdapter;
import org.apache.fop.accessibility.StructureTreeElement;
import org.apache.fop.accessibility.StructureTreeEventHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

final class IFStructureTreeBuilder
implements StructureTreeEventHandler {
    private StructureTreeEventHandler delegate;
    private final List<SAXEventRecorder> pageSequenceEventRecorders = new ArrayList<SAXEventRecorder>();
    private int idCounter;

    IFStructureTreeBuilder() {
    }

    public void replayEventsForPageSequence(ContentHandler contentHandler, int n) throws SAXException {
        this.pageSequenceEventRecorders.get(n).replay(contentHandler);
    }

    public void startPageSequence(Locale locale, String string) {
        SAXEventRecorder sAXEventRecorder = new SAXEventRecorder();
        this.pageSequenceEventRecorders.add(sAXEventRecorder);
        this.delegate = StructureTree2SAXEventAdapter.newInstance(sAXEventRecorder);
        this.delegate.startPageSequence(locale, string);
    }

    public void endPageSequence() {
        this.delegate.endPageSequence();
    }

    public StructureTreeElement startNode(String string, Attributes attributes) {
        this.delegate.startNode(string, attributes);
        return new IFStructureTreeElement();
    }

    public void endNode(String string) {
        this.delegate.endNode(string);
    }

    public StructureTreeElement startImageNode(String string, Attributes attributes) {
        String string2 = this.getNextID();
        AttributesImpl attributesImpl = this.addIDAttribute(attributes, string2);
        this.delegate.startImageNode(string, attributesImpl);
        return new IFStructureTreeElement(string2);
    }

    public StructureTreeElement startReferencedNode(String string, Attributes attributes) {
        String string2 = this.getNextID();
        AttributesImpl attributesImpl = this.addIDAttribute(attributes, string2);
        this.delegate.startReferencedNode(string, attributesImpl);
        return new IFStructureTreeElement(string2);
    }

    private String getNextID() {
        return Integer.toHexString(this.idCounter++);
    }

    private AttributesImpl addIDAttribute(Attributes attributes, String string) {
        AttributesImpl attributesImpl = new AttributesImpl(attributes);
        attributesImpl.addAttribute("http://xmlgraphics.apache.org/fop/internal", "struct-id", "foi:struct-id", "CDATA", string);
        return attributesImpl;
    }

    static class SAXEventRecorder
    extends DefaultHandler {
        private final List<Event> events = new ArrayList<Event>();

        SAXEventRecorder() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.events.add(new StartElement(string, string2, string3, attributes));
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            this.events.add(new EndElement(string, string2, string3));
        }

        public void startPrefixMapping(String string, String string2) throws SAXException {
            this.events.add(new StartPrefixMapping(string, string2));
        }

        public void endPrefixMapping(String string) throws SAXException {
            this.events.add(new EndPrefixMapping(string));
        }

        public void replay(ContentHandler contentHandler) throws SAXException {
            for (Event event : this.events) {
                event.replay(contentHandler);
            }
        }

        private static final class EndPrefixMapping
        extends Event {
            private final String prefix;

            private EndPrefixMapping(String string) {
                this.prefix = string;
            }

            void replay(ContentHandler contentHandler) throws SAXException {
                contentHandler.endPrefixMapping(this.prefix);
            }
        }

        private static final class StartPrefixMapping
        extends Event {
            private final String prefix;
            private final String uri;

            private StartPrefixMapping(String string, String string2) {
                this.prefix = string;
                this.uri = string2;
            }

            void replay(ContentHandler contentHandler) throws SAXException {
                contentHandler.startPrefixMapping(this.prefix, this.uri);
            }
        }

        private static final class EndElement
        extends Element {
            private EndElement(String string, String string2, String string3) {
                super(string, string2, string3);
            }

            void replay(ContentHandler contentHandler) throws SAXException {
                contentHandler.endElement(this.uri, this.localName, this.qName);
            }
        }

        private static final class StartElement
        extends Element {
            private final Attributes attributes;

            private StartElement(String string, String string2, String string3, Attributes attributes) {
                super(string, string2, string3);
                this.attributes = attributes;
            }

            void replay(ContentHandler contentHandler) throws SAXException {
                contentHandler.startElement(this.uri, this.localName, this.qName, this.attributes);
            }
        }

        private static abstract class Element
        extends Event {
            protected final String uri;
            protected final String localName;
            protected final String qName;

            private Element(String string, String string2, String string3) {
                this.uri = string;
                this.localName = string2;
                this.qName = string3;
            }
        }

        private static abstract class Event {
            private Event() {
            }

            abstract void replay(ContentHandler var1) throws SAXException;
        }
    }

    static final class IFStructureTreeElement
    implements StructureTreeElement {
        private final String id;

        IFStructureTreeElement() {
            this.id = null;
        }

        IFStructureTreeElement(String string) {
            this.id = string;
        }

        public String getId() {
            return this.id;
        }
    }
}

