/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pcl;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.render.pcl.PCLGenerator;

final class HardcodedFonts {
    private static final Log LOG = LogFactory.getLog(HardcodedFonts.class);

    private HardcodedFonts() {
    }

    public static boolean setFont(PCLGenerator pCLGenerator, String string, int n, String string2) throws IOException {
        byte[] byArray = string2.getBytes("ISO-8859-1");
        int n2 = byArray.length;
        for (int i = 0; i < n2; ++i) {
            if (byArray[i] != 63 || string2.charAt(i) == '?') continue;
            return false;
        }
        return HardcodedFonts.selectFont(pCLGenerator, string, n);
    }

    private static boolean selectFont(PCLGenerator pCLGenerator, String string, int n) throws IOException {
        int n2 = 0;
        if (string.length() > 1 && string.charAt(0) == 'F') {
            try {
                n2 = Integer.parseInt(string.substring(1));
            }
            catch (Exception exception) {
                LOG.error((Object)exception);
            }
        }
        String string2 = pCLGenerator.formatDouble2((double)n / 1000.0);
        switch (n2) {
            case 1: {
                pCLGenerator.writeCommand("(0N");
                pCLGenerator.writeCommand("(s1p" + string2 + "v0s0b16602T");
                break;
            }
            case 2: {
                pCLGenerator.writeCommand("(0N");
                pCLGenerator.writeCommand("(s1p" + string2 + "v1s0b16602T");
                break;
            }
            case 3: {
                pCLGenerator.writeCommand("(0N");
                pCLGenerator.writeCommand("(s1p" + string2 + "v0s3b16602T");
                break;
            }
            case 4: {
                pCLGenerator.writeCommand("(0N");
                pCLGenerator.writeCommand("(s1p" + string2 + "v1s3b16602T");
                break;
            }
            case 5: {
                pCLGenerator.writeCommand("(0N");
                pCLGenerator.writeCommand("(s1p" + string2 + "v0s0b16901T");
                break;
            }
            case 6: {
                pCLGenerator.writeCommand("(0N");
                pCLGenerator.writeCommand("(s1p" + string2 + "v1s0b16901T");
                break;
            }
            case 7: {
                pCLGenerator.writeCommand("(0N");
                pCLGenerator.writeCommand("(s1p" + string2 + "v0s3b16901T");
                break;
            }
            case 8: {
                pCLGenerator.writeCommand("(0N");
                pCLGenerator.writeCommand("(s1p" + string2 + "v1s3b16901T");
                break;
            }
            case 9: {
                pCLGenerator.writeCommand("(0N");
                pCLGenerator.writeCommand("(s0p" + pCLGenerator.formatDouble2(120.01f / ((float)n / 1000.0f)) + "h0s0b4099T");
                break;
            }
            case 10: {
                pCLGenerator.writeCommand("(0N");
                pCLGenerator.writeCommand("(s0p" + pCLGenerator.formatDouble2(120.01f / ((float)n / 1000.0f)) + "h1s0b4099T");
                break;
            }
            case 11: {
                pCLGenerator.writeCommand("(0N");
                pCLGenerator.writeCommand("(s0p" + pCLGenerator.formatDouble2(120.01f / ((float)n / 1000.0f)) + "h0s3b4099T");
                break;
            }
            case 12: {
                pCLGenerator.writeCommand("(0N");
                pCLGenerator.writeCommand("(s0p" + pCLGenerator.formatDouble2(120.01f / ((float)n / 1000.0f)) + "h1s3b4099T");
                break;
            }
            case 13: {
                return false;
            }
            case 14: {
                return false;
            }
            default: {
                return false;
            }
        }
        return true;
    }
}

