/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pcl;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.RenderedImage;
import java.io.IOException;
import org.apache.fop.render.ImageHandler;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.pcl.PCLGenerator;
import org.apache.fop.render.pcl.PCLRenderingContext;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.impl.ImageRendered;

public class PCLImageHandlerRenderedImage
implements ImageHandler {
    public int getPriority() {
        return 300;
    }

    public Class getSupportedImageClass() {
        return ImageRendered.class;
    }

    public ImageFlavor[] getSupportedImageFlavors() {
        return new ImageFlavor[]{ImageFlavor.BUFFERED_IMAGE, ImageFlavor.RENDERED_IMAGE};
    }

    public void handleImage(RenderingContext renderingContext, Image image, Rectangle rectangle) throws IOException {
        PCLRenderingContext pCLRenderingContext = (PCLRenderingContext)renderingContext;
        ImageRendered imageRendered = (ImageRendered)image;
        PCLGenerator pCLGenerator = pCLRenderingContext.getPCLGenerator();
        RenderedImage renderedImage = imageRendered.getRenderedImage();
        Point2D point2D = pCLRenderingContext.transformedPoint(rectangle.x, rectangle.y);
        pCLGenerator.setCursorPos(point2D.getX(), point2D.getY());
        pCLGenerator.paintBitmap(renderedImage, new Dimension(rectangle.width, rectangle.height), pCLRenderingContext.isSourceTransparencyEnabled());
    }

    public boolean isCompatible(RenderingContext renderingContext, Image image) {
        return (image == null || image instanceof ImageRendered) && renderingContext instanceof PCLRenderingContext;
    }
}

