/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pcl;

import org.apache.fop.render.ImageHandlerUtil;
import org.apache.fop.render.RendererContext;
import org.apache.fop.render.pcl.PCLConstants;

public class PCLRendererContext
extends RendererContext.RendererContextWrapper {
    public static PCLRendererContext wrapRendererContext(RendererContext rendererContext) {
        PCLRendererContext pCLRendererContext = new PCLRendererContext(rendererContext);
        return pCLRendererContext;
    }

    public PCLRendererContext(RendererContext rendererContext) {
        super(rendererContext);
    }

    public boolean paintAsBitmap() {
        return ImageHandlerUtil.isConversionModeBitmap(this.getForeignAttributes());
    }

    public boolean isClippingDisabled() {
        return this.getForeignAttributes() != null && "true".equalsIgnoreCase((String)this.getForeignAttributes().get(PCLConstants.DISABLE_CLIPPING));
    }

    public boolean isSourceTransparency() {
        return this.getForeignAttributes() != null && "true".equalsIgnoreCase((String)this.getForeignAttributes().get(PCLConstants.SRC_TRANSPARENCY));
    }

    public boolean isColorCanvas() {
        Boolean bl = (Boolean)this.context.getProperty("color-canvas");
        return Boolean.TRUE.equals(bl) || this.getForeignAttributes() != null && "true".equalsIgnoreCase((String)this.getForeignAttributes().get(PCLConstants.COLOR_CANVAS));
    }
}

