/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.awt.color.ColorSpace;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.pdf.CCFFilter;
import org.apache.fop.pdf.PDFDeviceColorSpace;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFFilter;
import org.apache.fop.render.pdf.AbstractImageAdapter;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.impl.ImageRawCCITTFax;

public class ImageRawCCITTFaxAdapter
extends AbstractImageAdapter {
    private PDFFilter pdfFilter = null;

    public ImageRawCCITTFaxAdapter(ImageRawCCITTFax imageRawCCITTFax, String string) {
        super((Image)imageRawCCITTFax, string);
    }

    public ImageRawCCITTFax getImage() {
        return (ImageRawCCITTFax)this.image;
    }

    public void setup(PDFDocument pDFDocument) {
        this.pdfFilter = new CCFFilter();
        this.pdfFilter.setApplied(true);
        PDFDictionary pDFDictionary = new PDFDictionary();
        pDFDictionary.put("Columns", this.image.getSize().getWidthPx());
        int n = this.getImage().getCompression();
        switch (n) {
            case 2: {
                pDFDictionary.put("K", 0);
                break;
            }
            case 3: {
                pDFDictionary.put("K", 1);
                break;
            }
            case 4: {
                pDFDictionary.put("K", -1);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid compression scheme: " + n);
            }
        }
        ((CCFFilter)this.pdfFilter).setDecodeParms(pDFDictionary);
        super.setup(pDFDocument);
    }

    public PDFDeviceColorSpace getColorSpace() {
        return ImageRawCCITTFaxAdapter.toPDFColorSpace(ColorSpace.getInstance(1003));
    }

    public int getBitsPerComponent() {
        return 1;
    }

    public PDFFilter getPDFFilter() {
        return this.pdfFilter;
    }

    public void outputContents(OutputStream outputStream) throws IOException {
        this.getImage().writeTo(outputStream);
    }

    public String getFilterHint() {
        return "tiff";
    }
}

