/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.ps.ImageEncoderCCITTFax;
import org.apache.fop.render.ps.PSImageFormResource;
import org.apache.fop.render.ps.PSImageHandler;
import org.apache.fop.render.ps.PSRenderingContext;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.impl.ImageRawCCITTFax;
import org.apache.xmlgraphics.ps.ImageEncoder;
import org.apache.xmlgraphics.ps.ImageFormGenerator;
import org.apache.xmlgraphics.ps.PSGenerator;
import org.apache.xmlgraphics.ps.PSImageUtils;

public class PSImageHandlerRawCCITTFax
implements PSImageHandler {
    private static final ImageFlavor[] FLAVORS = new ImageFlavor[]{ImageFlavor.RAW_CCITTFAX};

    public void handleImage(RenderingContext renderingContext, Image image, Rectangle rectangle) throws IOException {
        PSRenderingContext pSRenderingContext = (PSRenderingContext)renderingContext;
        PSGenerator pSGenerator = pSRenderingContext.getGenerator();
        ImageRawCCITTFax imageRawCCITTFax = (ImageRawCCITTFax)image;
        float f = (float)rectangle.getX() / 1000.0f;
        float f2 = (float)rectangle.getY() / 1000.0f;
        float f3 = (float)rectangle.getWidth() / 1000.0f;
        float f4 = (float)rectangle.getHeight() / 1000.0f;
        Rectangle2D.Float float_ = new Rectangle2D.Float(f, f2, f3, f4);
        ImageInfo imageInfo = image.getInfo();
        ImageEncoderCCITTFax imageEncoderCCITTFax = new ImageEncoderCCITTFax(imageRawCCITTFax);
        PSImageUtils.writeImage((ImageEncoder)imageEncoderCCITTFax, (Dimension)imageInfo.getSize().getDimensionPx(), (String)imageInfo.getOriginalURI(), (Rectangle2D)float_, (ColorSpace)imageRawCCITTFax.getColorSpace(), (int)1, (boolean)false, (PSGenerator)pSGenerator);
    }

    public void generateForm(RenderingContext renderingContext, Image image, PSImageFormResource pSImageFormResource) throws IOException {
        PSRenderingContext pSRenderingContext = (PSRenderingContext)renderingContext;
        PSGenerator pSGenerator = pSRenderingContext.getGenerator();
        ImageRawCCITTFax imageRawCCITTFax = (ImageRawCCITTFax)image;
        ImageInfo imageInfo = image.getInfo();
        String string = imageInfo.getMimeType() + " " + imageInfo.getOriginalURI();
        ImageEncoderCCITTFax imageEncoderCCITTFax = new ImageEncoderCCITTFax(imageRawCCITTFax);
        ImageFormGenerator imageFormGenerator = new ImageFormGenerator(pSImageFormResource.getName(), string, imageInfo.getSize().getDimensionPt(), imageInfo.getSize().getDimensionPx(), (ImageEncoder)imageEncoderCCITTFax, imageRawCCITTFax.getColorSpace(), 1, false);
        imageFormGenerator.generate(pSGenerator);
    }

    public int getPriority() {
        return 200;
    }

    public Class getSupportedImageClass() {
        return ImageRawCCITTFax.class;
    }

    public ImageFlavor[] getSupportedImageFlavors() {
        return FLAVORS;
    }

    public boolean isCompatible(RenderingContext renderingContext, Image image) {
        PSRenderingContext pSRenderingContext;
        if (renderingContext instanceof PSRenderingContext && (pSRenderingContext = (PSRenderingContext)renderingContext).getGenerator().getPSLevel() >= 2) {
            return image == null || image instanceof ImageRawCCITTFax;
        }
        return false;
    }
}

