/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps.fonts;

import java.io.IOException;
import org.apache.xmlgraphics.ps.PSGenerator;
import org.apache.xmlgraphics.util.io.ASCIIHexOutputStream;

public class PSTTFGenerator {
    private PSGenerator gen;
    private ASCIIHexOutputStream hexOut;
    public static final int MAX_BUFFER_SIZE = 32764;

    public PSTTFGenerator(PSGenerator pSGenerator) {
        this.gen = pSGenerator;
        this.hexOut = new ASCIIHexOutputStream(pSGenerator.getOutputStream());
    }

    public void startString() throws IOException {
        this.hexOut = new ASCIIHexOutputStream(this.gen.getOutputStream());
        this.gen.writeln("<");
    }

    public void write(String string) throws IOException {
        this.gen.write(string);
    }

    public void writeln(String string) throws IOException {
        this.gen.writeln(string);
    }

    public void streamBytes(byte[] byArray, int n, int n2) throws IOException {
        if (n2 > 32764) {
            throw new UnsupportedOperationException("Attempting to write a string to a PostScript file that is greater than the buffer size.");
        }
        this.hexOut.write(byArray, n, n2);
    }

    public void endString() throws IOException {
        this.gen.write("00\n> ");
    }
}

