/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf.rtflib.rtfdoc;

import java.io.IOException;
import java.io.Writer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfElement;

public class RtfBookmark
extends RtfElement {
    private String bookmark = null;
    public static final int MAX_BOOKMARK_LENGTH = 40;
    public static final char REPLACE_CHARACTER = '_';

    RtfBookmark(RtfContainer rtfContainer, Writer writer, String string) throws IOException {
        super(rtfContainer, writer);
        int n = string.length();
        this.bookmark = string.substring(0, n < 40 ? n : 40);
        this.bookmark = this.bookmark.replace('.', '_');
        this.bookmark = this.bookmark.replace(' ', '_');
    }

    public void writeRtfPrefix() throws IOException {
        this.startBookmark();
    }

    public void writeRtfContent() throws IOException {
    }

    public void writeRtfSuffix() throws IOException {
        this.endBookmark();
    }

    private void startBookmark() throws IOException {
        this.writeRtfBookmark("bkmkstart");
    }

    private void endBookmark() throws IOException {
        this.writeRtfBookmark("bkmkend");
    }

    private void writeRtfBookmark(String string) throws IOException {
        if (this.bookmark == null) {
            return;
        }
        this.writeGroupMark(true);
        this.writeStarControlWord(string);
        this.writer.write(this.bookmark);
        this.writeGroupMark(false);
    }

    public boolean isEmpty() {
        return this.bookmark == null || this.bookmark.trim().length() == 0;
    }
}

