/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf.rtflib.rtfdoc;

import java.io.IOException;
import java.io.Writer;
import org.apache.fop.apps.FOPException;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IBorderAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.ITableAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfElement;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTable;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTableCell;

public class RtfTableRow
extends RtfContainer
implements ITableAttributes {
    private RtfTableCell cell;
    private int id;
    private int highestCell = 0;

    RtfTableRow(RtfTable rtfTable, Writer writer, int n) throws IOException {
        super(rtfTable, writer);
        this.id = n;
    }

    RtfTableRow(RtfTable rtfTable, Writer writer, RtfAttributes rtfAttributes, int n) throws IOException {
        super(rtfTable, writer, rtfAttributes);
        this.id = n;
    }

    public RtfTableCell newTableCell(int n) throws IOException {
        ++this.highestCell;
        this.cell = new RtfTableCell(this, this.writer, n, this.highestCell);
        return this.cell;
    }

    public RtfTableCell newTableCell(int n, RtfAttributes rtfAttributes) throws IOException {
        ++this.highestCell;
        this.cell = new RtfTableCell(this, this.writer, n, rtfAttributes, this.highestCell);
        return this.cell;
    }

    public RtfTableCell newTableCellMergedVertically(int n, RtfAttributes rtfAttributes) throws IOException {
        ++this.highestCell;
        this.cell = new RtfTableCell(this, this.writer, n, rtfAttributes, this.highestCell);
        this.cell.setVMerge(2);
        return this.cell;
    }

    public RtfTableCell newTableCellMergedHorizontally(int n, RtfAttributes rtfAttributes) throws IOException, FOPException {
        ++this.highestCell;
        RtfAttributes rtfAttributes2 = null;
        if (rtfAttributes != null) {
            try {
                rtfAttributes2 = (RtfAttributes)rtfAttributes.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new FOPException(cloneNotSupportedException);
            }
        }
        this.cell = new RtfTableCell(this, this.writer, n, rtfAttributes2, this.highestCell);
        this.cell.setHMerge(2);
        return this.cell;
    }

    protected void writeRtfPrefix() throws IOException {
        this.newLine();
        this.writeGroupMark(true);
    }

    protected void writeRtfContent() throws IOException {
        if (this.getTable().isNestedTable()) {
            this.writeControlWord("intbl");
            this.writeControlWord("itap" + this.getTable().getNestedTableDepth());
        } else {
            this.writeRowAndCellsDefintions();
        }
        super.writeRtfContent();
    }

    public void writeRowAndCellsDefintions() throws IOException {
        this.writeControlWord("trowd");
        if (!this.getTable().isNestedTable()) {
            this.writeControlWord("itap0");
        }
        if (this.attrib != null && this.attrib.isSet("trkeep")) {
            this.writeControlWord("trkeep");
        }
        this.writePaddingAttributes();
        RtfTable rtfTable = (RtfTable)this.parent;
        this.adjustBorderProperties(rtfTable);
        this.writeAttributes(this.attrib, new String[]{"trhdr"});
        this.writeAttributes(this.attrib, ITableAttributes.ROW_BORDER);
        this.writeAttributes(this.attrib, ITableAttributes.CELL_BORDER);
        this.writeAttributes(this.attrib, IBorderAttributes.BORDERS);
        if (this.attrib.isSet("trrh")) {
            this.writeOneAttribute("trrh", this.attrib.getValue("trrh"));
        }
        int n = 0;
        Object object = this.attrib.getValue("trleft");
        if (object != null) {
            n = (Integer)object;
        }
        RtfAttributes rtfAttributes = this.getTable().getBorderAttributes();
        int n2 = 0;
        for (RtfElement rtfElement : this.getChildren()) {
            if (rtfElement instanceof RtfTableCell) {
                RtfTableCell rtfTableCell = (RtfTableCell)rtfElement;
                if (rtfAttributes != null) {
                    String string;
                    if (n2 == 0) {
                        string = "clbrdrl";
                        if (!rtfTableCell.getRtfAttributes().isSet(string)) {
                            rtfTableCell.getRtfAttributes().set(string, (RtfAttributes)rtfAttributes.getValue(string));
                        }
                    }
                    if (n2 == this.getChildCount() - 1) {
                        string = "clbrdrr";
                        if (!rtfTableCell.getRtfAttributes().isSet(string)) {
                            rtfTableCell.getRtfAttributes().set(string, (RtfAttributes)rtfAttributes.getValue(string));
                        }
                    }
                    if (this.isFirstRow()) {
                        string = "clbrdrt";
                        if (!rtfTableCell.getRtfAttributes().isSet(string)) {
                            rtfTableCell.getRtfAttributes().set(string, (RtfAttributes)rtfAttributes.getValue(string));
                        }
                    }
                    if (rtfTable != null && rtfTable.isHighestRow(this.id)) {
                        string = "clbrdrb";
                        if (!rtfTableCell.getRtfAttributes().isSet(string)) {
                            rtfTableCell.getRtfAttributes().set(string, (RtfAttributes)rtfAttributes.getValue(string));
                        }
                    }
                }
                if (n2 == 0 && !rtfTableCell.getRtfAttributes().isSet("clbrdrl")) {
                    rtfTableCell.getRtfAttributes().set("clbrdrl", (String)this.attrib.getValue("trbrdrl"));
                }
                if (n2 == this.getChildCount() - 1 && !rtfTableCell.getRtfAttributes().isSet("clbrdrr")) {
                    rtfTableCell.getRtfAttributes().set("clbrdrr", (String)this.attrib.getValue("trbrdrr"));
                }
                if (this.isFirstRow() && !rtfTableCell.getRtfAttributes().isSet("clbrdrt")) {
                    rtfTableCell.getRtfAttributes().set("clbrdrt", (String)this.attrib.getValue("trbrdrt"));
                }
                if (rtfTable != null && rtfTable.isHighestRow(this.id) && !rtfTableCell.getRtfAttributes().isSet("clbrdrb")) {
                    rtfTableCell.getRtfAttributes().set("clbrdrb", (String)this.attrib.getValue("trbrdrb"));
                }
                n = rtfTableCell.writeCellDef(n);
            }
            ++n2;
        }
        this.newLine();
    }

    private void adjustBorderProperties(RtfTable rtfTable) {
        if (this.attrib != null && rtfTable != null) {
            if (this.isFirstRow() && rtfTable.isHighestRow(this.id)) {
                this.attrib.unset("trbrdrh");
            } else if (this.isFirstRow()) {
                this.attrib.unset("trbrdrb");
            } else if (rtfTable.isHighestRow(this.id)) {
                this.attrib.unset("trbrdrt");
            } else {
                this.attrib.unset("trbrdrb");
                this.attrib.unset("trbrdrt");
            }
        }
    }

    protected void writeRtfSuffix() throws IOException {
        if (this.getTable().isNestedTable()) {
            this.writeGroupMark(true);
            this.writeStarControlWord("nesttableprops");
            this.writeRowAndCellsDefintions();
            this.writeControlWordNS("nestrow");
            this.writeGroupMark(false);
            this.writeGroupMark(true);
            this.writeControlWord("nonesttables");
            this.writeControlWord("par");
            this.writeGroupMark(false);
        } else {
            this.writeControlWord("row");
        }
        this.writeGroupMark(false);
    }

    private void writePaddingAttributes() throws IOException {
        if (this.attrib != null && !this.attrib.isSet("trgaph")) {
            int n = -1;
            try {
                Integer n2;
                Integer n3 = (Integer)this.attrib.getValue("trpaddl");
                if (n3 != null) {
                    n = n3;
                }
                if ((n2 = (Integer)this.attrib.getValue("trpaddr")) != null) {
                    n = (n + n2) / 2;
                }
            }
            catch (Exception exception) {
                String string = "RtfTableRow.writePaddingAttributes: " + exception.toString();
            }
            if (n >= 0) {
                this.attrib.set("trgaph", n);
            }
        }
        this.writeAttributes(this.attrib, ATTRIB_ROW_PADDING);
    }

    public boolean isFirstRow() {
        return this.id == 1;
    }

    public boolean isHighestCell(int n) {
        return this.highestCell == n;
    }

    public RtfTable getTable() {
        RtfContainer rtfContainer = this;
        while (rtfContainer.parent != null) {
            if (rtfContainer.parent instanceof RtfTable) {
                return (RtfTable)rtfContainer.parent;
            }
            rtfContainer = rtfContainer.parent;
        }
        return null;
    }
}

