/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.servlet;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;

public class ServletContextURIResolver
implements URIResolver {
    public static final String SERVLET_CONTEXT_PROTOCOL = "servlet-context:";
    private ServletContext servletContext;

    public ServletContextURIResolver(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public Source resolve(String string, String string2) throws TransformerException {
        if (string.startsWith(SERVLET_CONTEXT_PROTOCOL)) {
            return this.resolveServletContextURI(string.substring(SERVLET_CONTEXT_PROTOCOL.length()));
        }
        if (string2 != null && string2.startsWith(SERVLET_CONTEXT_PROTOCOL) && string.indexOf(58) < 0) {
            String string3 = string2 + string;
            return this.resolveServletContextURI(string3.substring(SERVLET_CONTEXT_PROTOCOL.length()));
        }
        return null;
    }

    protected Source resolveServletContextURI(String string) throws TransformerException {
        while (string.startsWith("//")) {
            string = string.substring(1);
        }
        try {
            URL uRL = this.servletContext.getResource(string);
            InputStream inputStream = this.servletContext.getResourceAsStream(string);
            if (inputStream != null) {
                if (uRL != null) {
                    return new StreamSource(inputStream, uRL.toExternalForm());
                }
                return new StreamSource(inputStream);
            }
            throw new TransformerException("Resource does not exist. \"" + string + "\" is not accessible through the servlet context.");
        }
        catch (MalformedURLException malformedURLException) {
            throw new TransformerException("Error accessing resource using servlet context: " + string, malformedURLException);
        }
    }
}

