/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.dom.util.DocumentFactory;
import org.apache.batik.transcoder.ErrorHandler;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.keys.BooleanKey;
import org.apache.batik.transcoder.keys.FloatKey;
import org.apache.batik.util.ParsedURL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.SimpleLog;
import org.apache.fop.svg.FOPSAXSVGDocumentFactory;
import org.apache.xmlgraphics.image.loader.ImageContext;
import org.apache.xmlgraphics.image.loader.ImageManager;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.apache.xmlgraphics.image.loader.impl.AbstractImageSessionContext;
import org.w3c.dom.DOMImplementation;
import org.xml.sax.EntityResolver;

public abstract class AbstractFOPTranscoder
extends SVGAbstractTranscoder
implements Configurable {
    public static final TranscodingHints.Key KEY_DEVICE_RESOLUTION = new FloatKey();
    public static final TranscodingHints.Key KEY_STROKE_TEXT = new BooleanKey();
    public static final TranscodingHints.Key KEY_AUTO_FONTS = new BooleanKey();
    public static final Boolean VALUE_FORMAT_ON = Boolean.TRUE;
    public static final Boolean VALUE_FORMAT_OFF = Boolean.FALSE;
    protected UserAgent userAgent = this.createUserAgent();
    private Log logger;
    private EntityResolver resolver;
    private Configuration cfg = null;
    private ImageManager imageManager;
    private ImageSessionContext imageSessionContext;

    public AbstractFOPTranscoder() {
        this.hints.put((Object)KEY_DOCUMENT_ELEMENT_NAMESPACE_URI, (Object)"http://www.w3.org/2000/svg");
        this.hints.put((Object)KEY_DOCUMENT_ELEMENT, (Object)"svg");
        this.hints.put((Object)KEY_DOM_IMPLEMENTATION, (Object)SVGDOMImplementation.getDOMImplementation());
    }

    protected UserAgent createUserAgent() {
        return new FOPTranscoderUserAgent();
    }

    public void setLogger(Log log) {
        this.logger = log;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.resolver = entityResolver;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.cfg = configuration;
    }

    protected boolean getAutoFontsDefault() {
        return true;
    }

    protected Configuration getEffectiveConfiguration() {
        Configuration configuration = this.cfg;
        if (configuration == null) {
            boolean bl = this.getAutoFontsDefault();
            if (this.hints.containsKey((Object)KEY_AUTO_FONTS)) {
                bl = (Boolean)this.hints.get((Object)KEY_AUTO_FONTS);
            }
            if (bl) {
                DefaultConfiguration defaultConfiguration = new DefaultConfiguration("cfg");
                DefaultConfiguration defaultConfiguration2 = new DefaultConfiguration("fonts");
                defaultConfiguration.addChild((Configuration)defaultConfiguration2);
                DefaultConfiguration defaultConfiguration3 = new DefaultConfiguration("auto-detect");
                defaultConfiguration2.addChild((Configuration)defaultConfiguration3);
                configuration = defaultConfiguration;
            }
        }
        return configuration;
    }

    protected final Log getLogger() {
        if (this.logger == null) {
            this.logger = new SimpleLog("FOP/Transcoder");
            ((SimpleLog)this.logger).setLevel(3);
        }
        return this.logger;
    }

    protected DocumentFactory createDocumentFactory(DOMImplementation dOMImplementation, String string) {
        FOPSAXSVGDocumentFactory fOPSAXSVGDocumentFactory = new FOPSAXSVGDocumentFactory(string);
        if (this.resolver != null) {
            fOPSAXSVGDocumentFactory.setAdditionalEntityResolver(this.resolver);
        }
        return fOPSAXSVGDocumentFactory;
    }

    protected boolean isTextStroked() {
        boolean bl = false;
        if (this.hints.containsKey((Object)KEY_STROKE_TEXT)) {
            bl = (Boolean)this.hints.get((Object)KEY_STROKE_TEXT);
        }
        return bl;
    }

    protected float getDeviceResolution() {
        if (this.hints.containsKey((Object)KEY_DEVICE_RESOLUTION)) {
            return ((Float)this.hints.get((Object)KEY_DEVICE_RESOLUTION)).floatValue();
        }
        return 72.0f;
    }

    protected ImageManager getImageManager() {
        return this.imageManager;
    }

    protected ImageSessionContext getImageSessionContext() {
        return this.imageSessionContext;
    }

    protected void setupImageInfrastructure(final String string) {
        final ImageContext imageContext = new ImageContext(){

            public float getSourceResolution() {
                return 25.4f / AbstractFOPTranscoder.this.userAgent.getPixelUnitToMillimeter();
            }
        };
        this.imageManager = new ImageManager(imageContext);
        this.imageSessionContext = new AbstractImageSessionContext(){

            public ImageContext getParentContext() {
                return imageContext;
            }

            public float getTargetResolution() {
                return AbstractFOPTranscoder.this.getDeviceResolution();
            }

            public Source resolveURI(String string2) {
                try {
                    ParsedURL parsedURL = new ParsedURL(string, string2);
                    InputStream inputStream = parsedURL.openStream();
                    StreamSource streamSource = new StreamSource(inputStream, parsedURL.toString());
                    return streamSource;
                }
                catch (IOException iOException) {
                    AbstractFOPTranscoder.this.userAgent.displayError((Exception)iOException);
                    return null;
                }
            }
        };
    }

    protected class FOPTranscoderUserAgent
    extends SVGAbstractTranscoder.SVGAbstractTranscoderUserAgent {
        protected FOPTranscoderUserAgent() {
            super((SVGAbstractTranscoder)AbstractFOPTranscoder.this);
        }

        public void displayError(String string) {
            try {
                AbstractFOPTranscoder.this.getErrorHandler().error(new TranscoderException(string));
            }
            catch (TranscoderException transcoderException) {
                throw new RuntimeException();
            }
        }

        public void displayError(Exception exception) {
            try {
                AbstractFOPTranscoder.this.getErrorHandler().error(new TranscoderException(exception));
            }
            catch (TranscoderException transcoderException) {
                throw new RuntimeException();
            }
        }

        public void displayMessage(String string) {
            AbstractFOPTranscoder.this.getLogger().info((Object)string);
        }

        public float getPixelUnitToMillimeter() {
            TranscodingHints.Key key = ImageTranscoder.KEY_PIXEL_UNIT_TO_MILLIMETER;
            if (AbstractFOPTranscoder.this.getTranscodingHints().containsKey((Object)key)) {
                return ((Float)AbstractFOPTranscoder.this.getTranscodingHints().get((Object)key)).floatValue();
            }
            return 0.26458332f;
        }

        public String getMedia() {
            return "print";
        }
    }

    protected class FOPErrorHandler
    implements ErrorHandler {
        protected FOPErrorHandler() {
        }

        public void error(TranscoderException transcoderException) throws TranscoderException {
            AbstractFOPTranscoder.this.getLogger().error((Object)transcoderException.getMessage());
        }

        public void fatalError(TranscoderException transcoderException) throws TranscoderException {
            throw transcoderException;
        }

        public void warning(TranscoderException transcoderException) throws TranscoderException {
            AbstractFOPTranscoder.this.getLogger().warn((Object)transcoderException.getMessage());
        }
    }
}

