/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import org.apache.fop.Version;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontSetup;
import org.apache.fop.pdf.PDFAnnotList;
import org.apache.fop.pdf.PDFColorHandler;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFNumber;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.pdf.PDFPaintingState;
import org.apache.fop.pdf.PDFResources;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.svg.PDFContext;
import org.apache.fop.svg.PDFGraphics2D;

public class PDFDocumentGraphics2D
extends PDFGraphics2D {
    private final PDFContext pdfContext;
    private int width;
    private int height;
    private float svgWidth;
    private float svgHeight;
    public static final int NORMAL_PDF_RESOLUTION = 72;
    public static final int DEFAULT_NATIVE_DPI = 300;
    private float deviceDPI = 300.0f;
    protected Shape initialClip;
    protected AffineTransform initialTransform;

    public PDFDocumentGraphics2D(boolean bl) {
        super(bl);
        this.pdfDoc = new PDFDocument("Apache FOP Version " + Version.getVersion() + ": PDFDocumentGraphics2D");
        this.pdfContext = new PDFContext();
        this.colorHandler = new PDFColorHandler(this.pdfDoc.getResources());
    }

    public PDFDocumentGraphics2D(boolean bl, OutputStream outputStream, int n, int n2) throws IOException {
        this(bl);
        this.setupDocument(outputStream, n, n2);
    }

    public PDFDocumentGraphics2D() {
        this(false);
    }

    public void setupDocument(OutputStream outputStream, int n, int n2) throws IOException {
        this.width = n;
        this.height = n2;
        this.pdfDoc.outputHeader(outputStream);
        this.setOutputStream(outputStream);
    }

    public void setupDefaultFontInfo() {
        if (this.fontInfo == null) {
            FontInfo fontInfo = new FontInfo();
            boolean bl = false;
            FontSetup.setup(fontInfo, bl);
            this.setFontInfo(fontInfo);
        }
    }

    public void setDeviceDPI(float f) {
        this.deviceDPI = f;
    }

    public float getDeviceDPI() {
        return this.deviceDPI;
    }

    public void setFontInfo(FontInfo fontInfo) {
        this.fontInfo = fontInfo;
    }

    public FontInfo getFontInfo() {
        return this.fontInfo;
    }

    public PDFDocument getPDFDocument() {
        return this.pdfDoc;
    }

    public PDFContext getPDFContext() {
        return this.pdfContext;
    }

    public void setSVGDimension(float f, float f2) {
        this.svgWidth = f;
        this.svgHeight = f2;
    }

    public void setBackgroundColor(Color color) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("q\n");
        this.colorHandler.establishColor(stringBuffer, color, true);
        stringBuffer.append("0 0 ").append(this.width).append(" ").append(this.height).append(" re\n");
        stringBuffer.append("f\n");
        stringBuffer.append("Q\n");
        this.currentStream.write(stringBuffer.toString());
    }

    public void nextPage() {
        this.closePage();
    }

    public void nextPage(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.nextPage();
    }

    protected void closePage() {
        if (!this.pdfContext.isPagePending()) {
            return;
        }
        this.currentStream.write("Q\n");
        PDFStream pDFStream = this.pdfDoc.getFactory().makeStream("content", false);
        pDFStream.add(this.getString());
        this.currentStream = null;
        this.pdfDoc.registerObject(pDFStream);
        this.pdfContext.getCurrentPage().setContents(pDFStream);
        PDFAnnotList pDFAnnotList = this.pdfContext.getCurrentPage().getAnnotations();
        if (pDFAnnotList != null) {
            this.pdfDoc.addObject(pDFAnnotList);
        }
        this.pdfDoc.addObject(this.pdfContext.getCurrentPage());
        this.pdfContext.clearCurrentPage();
    }

    protected void preparePainting() {
        if (this.pdfContext.isPagePending()) {
            return;
        }
        if (!this.textAsShapes && this.getFontInfo() == null) {
            this.setupDefaultFontInfo();
        }
        try {
            this.startPage();
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
    }

    protected void startPage() throws IOException {
        double d;
        if (this.pdfContext.isPagePending()) {
            throw new IllegalStateException("Close page first before starting another");
        }
        this.paintingState = new PDFPaintingState();
        if (this.initialTransform == null) {
            this.initialTransform = this.getTransform();
            this.initialClip = this.getClip();
        } else {
            this.setTransform(this.initialTransform);
            this.setClip(this.initialClip);
        }
        this.currentFontName = "";
        this.currentFontSize = 0.0f;
        if (this.currentStream == null) {
            this.currentStream = new StringWriter();
        }
        PDFResources pDFResources = this.pdfDoc.getResources();
        PDFPage pDFPage = this.pdfDoc.getFactory().makePage(pDFResources, this.width, this.height);
        this.resourceContext = pDFPage;
        this.pdfContext.setCurrentPage(pDFPage);
        this.pageRef = pDFPage.referencePDF();
        this.currentStream.write("q\n");
        AffineTransform affineTransform = new AffineTransform(1.0, 0.0, 0.0, -1.0, 0.0, (double)this.height);
        this.currentStream.write("1 0 0 -1 0 " + this.height + " cm\n");
        if (this.svgWidth != 0.0f) {
            d = (float)this.width / this.svgWidth;
            double d2 = (float)this.height / this.svgHeight;
            affineTransform.scale(d, d2);
            this.currentStream.write("" + PDFNumber.doubleOut(d) + " 0 0 " + PDFNumber.doubleOut(d2) + " 0 0 cm\n");
        }
        if (this.deviceDPI != 72.0f) {
            d = 72.0f / this.deviceDPI;
            affineTransform.scale(d, d);
            this.currentStream.write("" + PDFNumber.doubleOut(d) + " 0 0 " + PDFNumber.doubleOut(d) + " 0 0 cm\n");
            this.scale(1.0 / d, 1.0 / d);
        }
        this.paintingState.concatenate(affineTransform);
        this.pdfContext.increasePageCount();
    }

    public void finish() throws IOException {
        this.closePage();
        if (this.fontInfo != null) {
            this.pdfDoc.getResources().addFonts(this.pdfDoc, this.fontInfo);
        }
        this.pdfDoc.output(this.outputStream);
        this.pdfDoc.outputTrailer(this.outputStream);
        this.outputStream.flush();
    }

    public PDFDocumentGraphics2D(PDFDocumentGraphics2D pDFDocumentGraphics2D) {
        super(pDFDocumentGraphics2D);
        this.pdfContext = pDFDocumentGraphics2D.pdfContext;
        this.width = pDFDocumentGraphics2D.width;
        this.height = pDFDocumentGraphics2D.height;
        this.svgWidth = pDFDocumentGraphics2D.svgWidth;
        this.svgHeight = pDFDocumentGraphics2D.svgHeight;
    }

    public Graphics create() {
        this.preparePainting();
        return new PDFDocumentGraphics2D(this);
    }

    public void drawString(String string, float f, float f2) {
        if (this.textAsShapes) {
            Font font = super.getFont();
            FontRenderContext fontRenderContext = super.getFontRenderContext();
            GlyphVector glyphVector = font.createGlyphVector(fontRenderContext, string);
            Shape shape = glyphVector.getOutline(f, f2);
            super.fill(shape);
        } else {
            super.drawString(string, f, f2);
        }
    }
}

