/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.text.AttributedCharacterIterator;
import org.apache.batik.gvt.font.GVTGlyphVector;
import org.apache.batik.gvt.renderer.StrokingTextPainter;
import org.apache.batik.gvt.text.TextPaintInfo;
import org.apache.batik.gvt.text.TextSpanLayout;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.svg.NativeTextPainter;
import org.apache.fop.svg.PDFGraphics2D;
import org.apache.fop.svg.PDFTextUtil;
import org.apache.fop.util.CharUtilities;

class PDFTextPainter
extends NativeTextPainter {
    private static final boolean DEBUG = false;

    public PDFTextPainter(FontInfo fontInfo) {
        super(fontInfo);
    }

    protected boolean isSupported(Graphics2D graphics2D) {
        return graphics2D instanceof PDFGraphics2D;
    }

    protected void paintTextRun(StrokingTextPainter.TextRun textRun, Graphics2D graphics2D) {
        AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
        attributedCharacterIterator.first();
        TextPaintInfo textPaintInfo = (TextPaintInfo)attributedCharacterIterator.getAttribute(PAINT_INFO);
        if (textPaintInfo == null || !textPaintInfo.visible) {
            return;
        }
        if (textPaintInfo != null && textPaintInfo.composite != null) {
            graphics2D.setComposite(textPaintInfo.composite);
        }
        TextSpanLayout textSpanLayout = textRun.getLayout();
        this.logTextRun(attributedCharacterIterator, textSpanLayout);
        CharSequence charSequence = this.collectCharacters(attributedCharacterIterator);
        attributedCharacterIterator.first();
        final PDFGraphics2D pDFGraphics2D = (PDFGraphics2D)((Object)graphics2D);
        PDFTextUtil pDFTextUtil = new PDFTextUtil(pDFGraphics2D.fontInfo){

            protected void write(String string) {
                pDFGraphics2D.currentStream.write(string);
            }
        };
        Object var9_9 = null;
        Font[] fontArray = this.findFonts(attributedCharacterIterator);
        if (fontArray == null || fontArray.length == 0) {
            textRun.getLayout().draw(graphics2D);
            return;
        }
        pDFGraphics2D.saveGraphicsState();
        pDFTextUtil.concatMatrix(graphics2D.getTransform());
        Shape shape = graphics2D.getClip();
        pDFGraphics2D.writeClip(shape);
        this.applyColorAndPaint(textPaintInfo, pDFGraphics2D);
        pDFTextUtil.beginTextObject();
        pDFTextUtil.setFonts(fontArray);
        boolean bl = textPaintInfo.strokePaint != null && textPaintInfo.strokeStroke != null;
        pDFTextUtil.setTextRenderingMode(textPaintInfo.fillPaint != null, bl, false);
        AffineTransform affineTransform = new AffineTransform();
        Point2D point2D = null;
        double d = 0.0;
        GVTGlyphVector gVTGlyphVector = textSpanLayout.getGlyphVector();
        int n = gVTGlyphVector.getNumGlyphs();
        for (int i = 0; i < n; ++i) {
            boolean bl2;
            char c = charSequence.charAt(i);
            boolean bl3 = gVTGlyphVector.isGlyphVisible(i) || CharUtilities.isAnySpace(c) && !CharUtilities.isZeroWidthSpace(c);
            this.logCharacter(c, textSpanLayout, i, bl3);
            if (!bl3) continue;
            Point2D point2D2 = gVTGlyphVector.getGlyphPosition(i);
            AffineTransform affineTransform2 = gVTGlyphVector.getGlyphTransform(i);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("pos " + point2D2 + ", transform " + affineTransform2));
            }
            affineTransform.setToIdentity();
            affineTransform.translate(point2D2.getX(), point2D2.getY());
            if (affineTransform2 != null) {
                affineTransform.concatenate(affineTransform2);
            }
            affineTransform.scale(1.0, -1.0);
            boolean bl4 = bl2 = point2D == null || point2D.getY() != point2D2.getY() || affineTransform2 != null;
            if (bl2) {
                if (i > 0) {
                    pDFTextUtil.writeTJ();
                    pDFTextUtil.writeTextMatrix(affineTransform);
                }
            } else {
                double d2 = point2D2.getX() - point2D.getX();
                Font font = pDFTextUtil.getCurrentFont();
                double d3 = d;
                double d4 = 1000.0 * d2 - d3;
                if (d4 != 0.0) {
                    double d5 = -d4 / (double)font.getFontSize();
                    pDFTextUtil.adjustGlyphTJ(d5 * 1000.0);
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("==> x diff: " + d2 + ", " + d4 + ", charWidth: " + d3));
                }
            }
            Font font = pDFTextUtil.selectFontForChar(c);
            char c2 = CharUtilities.isAnySpace(c) ? (char)' ' : (char)c;
            char c3 = font.mapChar(c2);
            boolean bl5 = false;
            if (!pDFTextUtil.isMultiByteFont(font.getFontName())) {
                int n2 = c3 / 256;
                c3 = (char)(c3 % 256);
                if (pDFTextUtil.getCurrentEncoding() != n2) {
                    pDFTextUtil.setCurrentEncoding(n2);
                    bl5 = true;
                }
            }
            if (font != pDFTextUtil.getCurrentFont() || bl5) {
                pDFTextUtil.writeTJ();
                pDFTextUtil.setCurrentFont(font);
                pDFTextUtil.writeTf(font);
                pDFTextUtil.writeTextMatrix(affineTransform);
            }
            pDFTextUtil.writeTJMappedChar(c3);
            point2D = point2D2;
            d = pDFTextUtil.getCurrentFont().getCharWidth(charSequence.charAt(i));
        }
        pDFTextUtil.writeTJ();
        pDFTextUtil.endTextObject();
        pDFGraphics2D.restoreGraphicsState();
    }

    private void applyColorAndPaint(TextPaintInfo textPaintInfo, PDFGraphics2D pDFGraphics2D) {
        Color color;
        Paint paint = textPaintInfo.fillPaint;
        Paint paint2 = textPaintInfo.strokePaint;
        Stroke stroke = textPaintInfo.strokeStroke;
        int n = 255;
        if (paint instanceof Color) {
            color = (Color)paint;
            pDFGraphics2D.applyColor(color, true);
            n = color.getAlpha();
        }
        if (paint2 instanceof Color) {
            color = (Color)paint2;
            pDFGraphics2D.applyColor(color, false);
        }
        pDFGraphics2D.applyPaint(paint, true);
        pDFGraphics2D.applyStroke(stroke);
        if (paint2 != null) {
            pDFGraphics2D.applyPaint(paint2, false);
        }
        pDFGraphics2D.applyAlpha(n, 255);
    }
}

