/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.tools;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.impl.SimpleLog;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.cli.InputHandler;
import org.apache.fop.tools.anttasks.FileCompare;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TestConverter {
    private FopFactory fopFactory = FopFactory.newInstance();
    private boolean failOnly = false;
    private String outputFormat = "application/X-fop-areatree";
    private File destdir;
    private File compare = null;
    private String baseDir = "./";
    private Map differ = new HashMap();
    protected SimpleLog logger = new SimpleLog("FOP/Test");

    public static void main(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            System.out.println("test suite file name required");
        }
        TestConverter testConverter = new TestConverter();
        String string = "results";
        String string2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-failOnly")) {
                testConverter.setFailOnly(true);
                continue;
            }
            if (stringArray[i].equals("-pdf")) {
                testConverter.setOutputFormat("application/pdf");
                continue;
            }
            if (stringArray[i].equals("-rtf")) {
                testConverter.setOutputFormat("application/rtf");
                continue;
            }
            if (stringArray[i].equals("-ps")) {
                testConverter.setOutputFormat("application/postscript");
                continue;
            }
            if (stringArray[i].equals("-d")) {
                testConverter.setDebug(true);
                continue;
            }
            if (stringArray[i].equals("-b")) {
                testConverter.setBaseDir(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-results")) {
                string = stringArray[++i];
                continue;
            }
            string2 = stringArray[i];
        }
        if (string2 == null) {
            System.out.println("test suite file name required");
        }
        testConverter.runTests(string2, string, null);
    }

    public TestConverter() {
        this.logger.setLevel(5);
    }

    public void setOutputFormat(String string) {
        this.outputFormat = string;
    }

    public void setFailOnly(boolean bl) {
        this.failOnly = bl;
    }

    public void setBaseDir(String string) {
        this.baseDir = string;
    }

    public void setDebug(boolean bl) {
        if (bl) {
            this.logger.setLevel(2);
        } else {
            this.logger.setLevel(5);
        }
    }

    public Map runTests(String string, String string2, String string3) {
        this.logger.debug((Object)("running tests in file:" + string));
        try {
            Object object;
            if (string3 != null) {
                this.compare = new File(this.baseDir + "/" + string3);
            }
            this.destdir = new File(this.baseDir + "/" + string2);
            this.destdir.mkdirs();
            File file = new File(this.baseDir + "/" + string);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            NodeList nodeList = document.getChildNodes();
            if (nodeList.getLength() == 0) {
                return this.differ;
            }
            Element element = null;
            element = document.getDocumentElement();
            if (element.hasAttributes()) {
                object = element.getAttributes().getNamedItem("profile").getNodeValue();
                this.logger.debug((Object)("testing test suite:" + (String)object));
            }
            object = element.getChildNodes();
            for (int i = 0; i < object.getLength(); ++i) {
                Node node = object.item(i);
                if (!node.getNodeName().equals("testcases")) continue;
                this.runTestCase(node);
            }
        }
        catch (Exception exception) {
            this.logger.error((Object)"Error while running tests", (Throwable)exception);
        }
        return this.differ;
    }

    protected void runTestCase(Node node) {
        Object object;
        if (node.hasAttributes()) {
            object = node.getAttributes().getNamedItem("profile").getNodeValue();
            this.logger.debug((Object)("testing profile:" + (String)object));
        }
        object = node.getChildNodes();
        for (int i = 0; i < object.getLength(); ++i) {
            Node node2 = object.item(i);
            String string = node2.getNodeName();
            if (string.equals("testcases")) {
                this.runTestCase(node2);
                continue;
            }
            if (string.equals("test")) {
                this.runTest(node, node2);
                continue;
            }
            if (!string.equals("result")) continue;
        }
    }

    protected void runTest(Node node, Node node2) {
        String string;
        String string2 = node2.getAttributes().getNamedItem("id").getNodeValue();
        Node node3 = this.locateResult(node, string2);
        boolean bl = false;
        if (node3 != null) {
            string = node3.getAttributes().getNamedItem("agreement").getNodeValue();
            bl = string.equals("full");
        }
        if (bl && this.failOnly) {
            return;
        }
        string = node2.getAttributes().getNamedItem("xml").getNodeValue();
        Node node4 = node2.getAttributes().getNamedItem("xsl");
        String string3 = null;
        if (node4 != null) {
            string3 = node4.getNodeValue();
        }
        this.logger.debug((Object)("converting xml:" + string + " and xsl:" + string3 + " to area tree"));
        String string4 = string;
        Node node5 = node2.getAttributes().getNamedItem("results");
        if (node5 != null) {
            string4 = node5.getNodeValue();
        }
        try {
            File file;
            File file2;
            File file3 = new File(this.baseDir + "/" + string);
            String string5 = null;
            try {
                string5 = file3.getParentFile().toURI().toURL().toExternalForm();
            }
            catch (Exception exception) {
                this.logger.error((Object)"Error setting base directory");
            }
            InputHandler inputHandler = null;
            inputHandler = string3 == null ? new InputHandler(file3) : new InputHandler(file3, new File(this.baseDir + "/" + string3), null);
            FOUserAgent fOUserAgent = this.fopFactory.newFOUserAgent();
            fOUserAgent.setBaseURL(string5);
            fOUserAgent.getRendererOptions().put("fineDetail", new Boolean(false));
            fOUserAgent.getRendererOptions().put("consistentOutput", new Boolean(true));
            fOUserAgent.setProducer("Testsuite Converter");
            String string6 = string4;
            if (string6.endsWith(".xml") || string6.endsWith(".pdf")) {
                string6 = string6.substring(0, string6.length() - 4);
            }
            File file4 = new File(this.destdir, string6 + this.makeResultExtension());
            file4.getParentFile().mkdirs();
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file4));
            this.logger.debug((Object)("ddir:" + this.destdir + " on:" + file4.getName()));
            inputHandler.renderTo(fOUserAgent, this.outputFormat, bufferedOutputStream);
            ((OutputStream)bufferedOutputStream).close();
            if (this.compare != null && !this.compareFiles(file2 = new File(this.destdir, string6 + ".at.xml"), file = new File(this.compare, string6 + ".at.xml"))) {
                this.differ.put(string6 + ".at.xml", new Boolean(bl));
            }
        }
        catch (Exception exception) {
            this.logger.error((Object)"Error while running tests", (Throwable)exception);
        }
    }

    private String makeResultExtension() {
        if ("application/pdf".equals(this.outputFormat)) {
            return ".pdf";
        }
        if ("application/rtf".equals(this.outputFormat)) {
            return ".rtf";
        }
        if ("application/postscript".equals(this.outputFormat)) {
            return ".ps";
        }
        return ".at.xml";
    }

    protected boolean compareFiles(File file, File file2) {
        try {
            return FileCompare.compareFiles(file, file2);
        }
        catch (Exception exception) {
            this.logger.error((Object)"Error while comparing files", (Throwable)exception);
            return false;
        }
    }

    private Node locateResult(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string2;
            Node node2 = nodeList.item(i);
            String string3 = node2.getNodeName();
            if (!string3.equals("result") || !string.equals(string2 = node2.getAttributes().getNamedItem("id").getNodeValue())) continue;
            return node2;
        }
        return null;
    }
}

