/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.tools.fontlist;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.fop.Version;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.fonts.FontEventListener;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.tools.fontlist.FontListGenerator;
import org.apache.fop.tools.fontlist.FontListSerializer;
import org.apache.fop.tools.fontlist.FontSpec;
import org.apache.fop.util.GenerationHelperContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public final class FontListMain {
    private static final int GENERATE_CONSOLE = 0;
    private static final int GENERATE_XML = 1;
    private static final int GENERATE_FO = 2;
    private static final int GENERATE_RENDERED = 3;
    private FopFactory fopFactory = FopFactory.newInstance();
    private File configFile;
    private File outputFile;
    private String configMime = "application/pdf";
    private String outputMime;
    private int mode = 0;
    private String singleFamilyFilter;

    private FontListMain() throws SAXException, IOException {
    }

    private void prepare() throws SAXException, IOException {
        if (this.configFile != null) {
            this.fopFactory.setUserConfig(this.configFile);
        }
    }

    private ContentHandler getFOPContentHandler(OutputStream outputStream) throws FOPException {
        Fop fop = this.fopFactory.newFop(this.outputMime, outputStream);
        return fop.getDefaultHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateXML(SortedMap sortedMap, File file, String string) throws TransformerConfigurationException, SAXException, IOException {
        Object object;
        TransformerHandler transformerHandler;
        SAXTransformerFactory sAXTransformerFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        if (this.mode == 1) {
            transformerHandler = sAXTransformerFactory.newTransformerHandler();
        } else {
            object = this.getClass().getResource("fonts2fo.xsl");
            if (object == null) {
                throw new FileNotFoundException("Did not find resource: fonts2fo.xsl");
            }
            transformerHandler = sAXTransformerFactory.newTransformerHandler(new StreamSource(((URL)object).toExternalForm()));
        }
        if (string != null) {
            object = transformerHandler.getTransformer();
            ((Transformer)object).setParameter("single-family", string);
        }
        object = new FileOutputStream(file);
        object = new BufferedOutputStream((OutputStream)object);
        if (this.mode == 3) {
            transformerHandler.setResult(new SAXResult(this.getFOPContentHandler((OutputStream)object)));
        } else {
            transformerHandler.setResult(new StreamResult((OutputStream)object));
        }
        try {
            GenerationHelperContentHandler generationHelperContentHandler = new GenerationHelperContentHandler(transformerHandler, null);
            FontListSerializer fontListSerializer = new FontListSerializer();
            fontListSerializer.generateSAX(sortedMap, string, generationHelperContentHandler);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)object);
        }
    }

    private void generate() throws Exception {
        this.prepare();
        FontEventListener fontEventListener = new FontEventListener(){

            public void fontLoadingErrorAtAutoDetection(Object object, String string, Exception exception) {
                System.err.println("Could not load " + string + " (" + exception.getLocalizedMessage() + ")");
            }

            public void fontSubstituted(Object object, FontTriplet fontTriplet, FontTriplet fontTriplet2) {
            }

            public void glyphNotAvailable(Object object, char c, String string) {
            }

            public void fontDirectoryNotFound(Object object, String string) {
            }

            public void svgTextStrokedAsShapes(Object object, String string) {
            }
        };
        FontListGenerator fontListGenerator = new FontListGenerator();
        SortedMap sortedMap = fontListGenerator.listFonts(this.fopFactory, this.configMime, fontEventListener);
        if (this.mode == 0) {
            this.writeToConsole(sortedMap);
        } else {
            this.writeOutput(sortedMap);
        }
    }

    private void writeToConsole(SortedMap sortedMap) throws TransformerConfigurationException, SAXException, IOException {
        for (Map.Entry entry : sortedMap.entrySet()) {
            String string = (String)entry.getKey();
            System.out.println(string + ":");
            List list = (List)entry.getValue();
            for (FontSpec fontSpec : list) {
                System.out.println("  " + fontSpec.getKey() + " " + fontSpec.getFamilyNames());
                for (FontTriplet fontTriplet : fontSpec.getTriplets()) {
                    System.out.println("    " + fontTriplet.toString());
                }
            }
        }
    }

    private void writeOutput(SortedMap sortedMap) throws TransformerConfigurationException, SAXException, IOException {
        if (this.outputFile.isDirectory()) {
            System.out.println("Creating one file for each family...");
            for (Map.Entry entry : sortedMap.entrySet()) {
                String string;
                String string2 = (String)entry.getKey();
                System.out.println("Creating output file for " + string2 + "...");
                switch (this.mode) {
                    case 3: {
                        string = string2 + ".pdf";
                        break;
                    }
                    case 2: {
                        string = string2 + ".fo";
                        break;
                    }
                    case 1: {
                        string = string2 + ".xml";
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported mode");
                    }
                }
                File file = new File(this.outputFile, string);
                this.generateXML(sortedMap, file, string2);
            }
        } else {
            System.out.println("Creating output file...");
            this.generateXML(sortedMap, this.outputFile, this.singleFamilyFilter);
        }
        System.out.println(this.outputFile + " written.");
    }

    private static void printVersion() {
        System.out.println("Apache FOP " + Version.getVersion() + " - http://xmlgraphics.apache.org/fop/\n");
    }

    private static void printHelp() {
        FontListMain.printVersion();
        String string = FontListMain.class.getName();
        PrintStream printStream = System.out;
        printStream.println("USAGE");
        printStream.println("  java [vmargs] " + string + " [-c <config-file>] [-f <mime>] [[output-dir|output-file] [font-family]]");
        printStream.println();
        printStream.println("PARAMETERS");
        printStream.println("  config-file: an optional FOP configuration file");
        printStream.println("  mime: The MIME type of the output format for which to");
        printStream.println("        create the font list (defaults to application/pdf)");
        printStream.println("  output-dir: Creates one sample PDF per font-family");
        printStream.println("  output-file: writes the list as file (valid file extensions: xml, fo, pdf)");
        printStream.println("  font-family: filters to a single font family");
        printStream.println();
        printStream.println("EXAMPLE");
        printStream.println("  java [vmargs] " + string + " -c userconfig.xml all-fonts.pdf");
        printStream.println("  --> this generates a single PDF containing a sample");
        printStream.println("      of all configured fonts.");
        printStream.println("  java [vmargs] " + string + " -c userconfig.xml");
        printStream.println("  --> this prints all configured fonts to the console.");
        printStream.println();
    }

    private void parseArguments(String[] stringArray) {
        if (stringArray.length > 0) {
            String string;
            int n = 0;
            if ("--help".equals(stringArray[n]) || "-?".equals(stringArray[n]) || "-h".equals(stringArray[n])) {
                FontListMain.printHelp();
                System.exit(0);
            }
            if (n < stringArray.length - 1 && "-c".equals(stringArray[n])) {
                string = stringArray[n + 1];
                this.configFile = new File(string);
                n += 2;
            }
            if (n < stringArray.length - 1 && "-f".equals(stringArray[n])) {
                this.configMime = stringArray[n + 1];
                n += 2;
            }
            if (n < stringArray.length) {
                string = stringArray[n];
                this.outputFile = new File(string);
                if (this.outputFile.isDirectory()) {
                    this.mode = 3;
                    this.outputMime = "application/pdf";
                } else if (FilenameUtils.getExtension((String)string).equalsIgnoreCase("pdf")) {
                    this.mode = 3;
                    this.outputMime = "application/pdf";
                } else if (FilenameUtils.getExtension((String)string).equalsIgnoreCase("fo")) {
                    this.mode = 2;
                } else if (FilenameUtils.getExtension((String)string).equalsIgnoreCase("xml")) {
                    this.mode = 1;
                } else {
                    throw new IllegalArgumentException("Operating mode for the output file cannot be determined or is unsupported: " + string);
                }
                ++n;
            }
            if (n < stringArray.length) {
                this.singleFamilyFilter = stringArray[n];
            }
        } else {
            System.out.println("use --help or -? for usage information.");
        }
    }

    public static void main(String[] stringArray) {
        try {
            FontListMain fontListMain = new FontListMain();
            fontListMain.parseArguments(stringArray);
            fontListMain.generate();
        }
        catch (Throwable throwable) {
            FontListMain.printHelp();
            throwable.printStackTrace();
            System.exit(-1);
        }
    }
}

