/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.util.text;

import java.text.ChoiceFormat;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.fop.util.text.AdvancedMessageFormat;

public class ChoiceFieldPart
implements AdvancedMessageFormat.Part {
    private static final Pattern VARIABLE_REGEX = Pattern.compile("\\{([^\\}]+)\\}");
    private String fieldName;
    private ChoiceFormat choiceFormat;

    public ChoiceFieldPart(String string, String string2) {
        this.fieldName = string;
        this.choiceFormat = new ChoiceFormat(string2);
    }

    public boolean isGenerated(Map map) {
        Object v = map.get(this.fieldName);
        return v != null;
    }

    public void write(StringBuffer stringBuffer, Map map) {
        Object v = map.get(this.fieldName);
        Number number = (Number)v;
        String string = this.choiceFormat.format(number.doubleValue());
        Matcher matcher = VARIABLE_REGEX.matcher(string);
        if (matcher.find()) {
            AdvancedMessageFormat advancedMessageFormat = new AdvancedMessageFormat(string);
            advancedMessageFormat.format(map, stringBuffer);
        } else {
            stringBuffer.append(string);
        }
    }

    public String toString() {
        return "{" + this.fieldName + ",choice, ....}";
    }

    public static class Factory
    implements AdvancedMessageFormat.PartFactory {
        public AdvancedMessageFormat.Part newPart(String string, String string2) {
            return new ChoiceFieldPart(string, string2);
        }

        public String getFormat() {
            return "choice";
        }
    }
}

