/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.util.text;

import java.util.Map;
import org.apache.fop.util.text.AdvancedMessageFormat;
import org.apache.fop.util.text.IfFieldPart;

public class EqualsFieldPart
extends IfFieldPart {
    private String equalsValue;

    public EqualsFieldPart(String string, String string2) {
        super(string, string2);
    }

    protected void parseValues(String string) {
        String[] stringArray = AdvancedMessageFormat.COMMA_SEPARATOR_REGEX.split(string, 3);
        this.equalsValue = stringArray[0];
        if (stringArray.length == 1) {
            throw new IllegalArgumentException("'equals' format must have at least 2 parameters");
        }
        if (stringArray.length == 3) {
            this.ifValue = AdvancedMessageFormat.unescapeComma(stringArray[1]);
            this.elseValue = AdvancedMessageFormat.unescapeComma(stringArray[2]);
        } else {
            this.ifValue = AdvancedMessageFormat.unescapeComma(stringArray[1]);
        }
    }

    protected boolean isTrue(Map map) {
        Object v = map.get(this.fieldName);
        if (v != null) {
            return String.valueOf(v).equals(this.equalsValue);
        }
        return false;
    }

    public String toString() {
        return "{" + this.fieldName + ", equals " + this.equalsValue + "}";
    }

    public static class Factory
    implements AdvancedMessageFormat.PartFactory {
        public AdvancedMessageFormat.Part newPart(String string, String string2) {
            return new EqualsFieldPart(string, string2);
        }

        public String getFormat() {
            return "equals";
        }
    }
}

