/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.util.text;

import java.util.Map;
import org.apache.fop.util.text.AdvancedMessageFormat;

public class IfFieldPart
implements AdvancedMessageFormat.Part {
    protected String fieldName;
    protected String ifValue;
    protected String elseValue;

    public IfFieldPart(String string, String string2) {
        this.fieldName = string;
        this.parseValues(string2);
    }

    protected void parseValues(String string) {
        String[] stringArray = AdvancedMessageFormat.COMMA_SEPARATOR_REGEX.split(string, 2);
        if (stringArray.length == 2) {
            this.ifValue = AdvancedMessageFormat.unescapeComma(stringArray[0]);
            this.elseValue = AdvancedMessageFormat.unescapeComma(stringArray[1]);
        } else {
            this.ifValue = AdvancedMessageFormat.unescapeComma(string);
        }
    }

    public void write(StringBuffer stringBuffer, Map map) {
        boolean bl = this.isTrue(map);
        if (bl) {
            stringBuffer.append(this.ifValue);
        } else if (this.elseValue != null) {
            stringBuffer.append(this.elseValue);
        }
    }

    protected boolean isTrue(Map map) {
        Object v = map.get(this.fieldName);
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        return v != null;
    }

    public boolean isGenerated(Map map) {
        return this.isTrue(map) || this.elseValue != null;
    }

    public String toString() {
        return "{" + this.fieldName + ", if...}";
    }

    public static class Factory
    implements AdvancedMessageFormat.PartFactory {
        public AdvancedMessageFormat.Part newPart(String string, String string2) {
            return new IfFieldPart(string, string2);
        }

        public String getFormat() {
            return "if";
        }
    }
}

