/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.peermodel;

import com.mathworks.messageservice.MessageService;
import com.mathworks.messageservice.MessageServiceFactory;
import com.mathworks.peermodel.PeerModelManager;
import com.mathworks.peermodel.PeerModelManagerSyncable;
import com.mathworks.peermodel.PeerSynchronizer;
import java.lang.reflect.Constructor;
import java.util.logging.Logger;

class PeerSynchronizerFactory {
    static Logger logger = Logger.getLogger(PeerSynchronizerFactory.class.getSimpleName());
    private static volatile Class<? extends PeerSynchronizer> theClass = null;

    PeerSynchronizerFactory() {
    }

    static synchronized void setSynchronizer(Class<? extends PeerSynchronizer> clazz) {
        theClass = clazz;
    }

    static synchronized PeerSynchronizer getSynchronizer(String namespace, PeerModelManager manager, boolean isClient) {
        MessageService messageService = MessageServiceFactory.getMessageService();
        PeerSynchronizer peerSynchronizer = null;
        try {
            if (theClass == null) {
                return new PeerSynchronizerNoImpl();
            }
            Constructor<? extends PeerSynchronizer> constructor = theClass.getConstructor(String.class, PeerModelManagerSyncable.class, MessageService.class, Boolean.TYPE);
            peerSynchronizer = constructor.newInstance(namespace, manager, messageService, isClient);
        }
        catch (Exception e) {
            logger.warning("Could not create PeerSynchronizer");
        }
        return peerSynchronizer;
    }

    static class PeerSynchronizerNoImpl
    implements PeerSynchronizer {
        @Override
        public void remove() {
        }
    }
}

