/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.storage.hdfs;

import com.mathworks.storage.hdfs.FilesystemCache;
import com.mathworks.storage.provider.FileAttributes;
import com.mathworks.storage.provider.FileMetadata;
import com.mathworks.storage.provider.FolderAttributes;
import com.mathworks.storage.provider.FolderListEntry;
import com.mathworks.storage.provider.FolderMetadata;
import com.mathworks.storage.provider.Provider;
import com.mathworks.storage.provider.ProviderChannel;
import com.mathworks.storage.provider.ProviderErrorCode;
import com.mathworks.storage.provider.ProviderException;
import com.mathworks.storage.provider.StorageURI;
import java.net.URI;
import java.util.Date;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;

public abstract class HadoopProviderImpl
implements Provider {
    private FilesystemCache fs_cache_;

    public HadoopProviderImpl(String scheme) throws Exception {
        this.fs_cache_ = new FilesystemCache(scheme);
    }

    public abstract ProviderChannel getReadOnlyChannel(FSDataInputStream var1, FileStatus var2, StorageURI var3) throws Exception;

    public abstract ProviderChannel getWritableChannel(FSDataOutputStream var1, FileStatus var2, StorageURI var3) throws Exception;

    public boolean fileExists(StorageURI uri) throws ProviderException {
        try {
            final String stringIRI = uri.toString();
            FilesystemCache.FilesystemTaskRunner tr = this.fs_cache_.getTaskRunnerForIRI(stringIRI);
            return tr.runTask(new FilesystemCache.FilesystemTask<Boolean>(){

                @Override
                public Boolean run(FileSystem fs) throws Exception {
                    Path filepath = new Path(new URI(stringIRI));
                    return fs.exists(filepath) && fs.isFile(filepath);
                }
            });
        }
        catch (Exception e) {
            throw new ProviderException(ProviderErrorCode.ResourceNotFound, uri);
        }
    }

    public boolean folderExists(StorageURI uri) throws ProviderException {
        try {
            final String stringIRI = uri.toString();
            FilesystemCache.FilesystemTaskRunner tr = this.fs_cache_.getTaskRunnerForIRI(stringIRI);
            return tr.runTask(new FilesystemCache.FilesystemTask<Boolean>(){

                @Override
                public Boolean run(FileSystem fs) throws Exception {
                    Path filepath = new Path(new URI(stringIRI));
                    return fs.exists(filepath) && fs.isDirectory(filepath);
                }
            });
        }
        catch (Exception e) {
            throw new ProviderException(ProviderErrorCode.ResourceNotFound, uri);
        }
    }

    public void createFile(StorageURI uri) throws ProviderException {
        try {
            final String stringIRI = uri.toString();
            FilesystemCache.FilesystemTaskRunner tr = this.fs_cache_.getTaskRunnerForIRI(stringIRI);
            tr.runTask(new FilesystemCache.FilesystemTask<Object>(){

                @Override
                public Object run(FileSystem fs) throws Exception {
                    Path filepath = new Path(new URI(stringIRI));
                    fs.createNewFile(filepath);
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new ProviderException(ProviderErrorCode.ResourceNotFound, uri);
        }
    }

    public void createFolder(StorageURI uri) throws ProviderException {
        try {
            final String stringIRI = uri.toString();
            FilesystemCache.FilesystemTaskRunner tr = this.fs_cache_.getTaskRunnerForIRI(stringIRI);
            tr.runTask(new FilesystemCache.FilesystemTask<Object>(){

                @Override
                public Object run(FileSystem fs) throws Exception {
                    Path filepath = new Path(new URI(stringIRI));
                    fs.mkdirs(filepath);
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new ProviderException(ProviderErrorCode.ResourceNotFound, uri);
        }
    }

    public void removeFile(StorageURI uri) throws ProviderException {
        try {
            final String stringIRI = uri.toString();
            FilesystemCache.FilesystemTaskRunner tr = this.fs_cache_.getTaskRunnerForIRI(stringIRI);
            tr.runTask(new FilesystemCache.FilesystemTask<Object>(){

                @Override
                public Object run(FileSystem fs) throws Exception {
                    Path filepath = new Path(new URI(stringIRI));
                    fs.delete(filepath);
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new ProviderException(ProviderErrorCode.ResourceNotFound, uri);
        }
    }

    public void removeFolder(StorageURI uri) throws ProviderException {
        try {
            final String stringIRI = uri.toString();
            FilesystemCache.FilesystemTaskRunner tr = this.fs_cache_.getTaskRunnerForIRI(stringIRI);
            tr.runTask(new FilesystemCache.FilesystemTask<Object>(){

                @Override
                public Object run(FileSystem fs) throws Exception {
                    Path folderpath = new Path(new URI(stringIRI));
                    fs.delete(folderpath, true);
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new ProviderException(ProviderErrorCode.ResourceNotFound, uri);
        }
    }

    public FileAttributes getFileAttributes(final StorageURI uri) throws ProviderException {
        try {
            final String stringIRI = uri.toString();
            FilesystemCache.FilesystemTaskRunner tr = this.fs_cache_.getTaskRunnerForIRI(stringIRI);
            return tr.runTask(new FilesystemCache.FilesystemTask<FileAttributes>(){

                @Override
                public FileAttributes run(FileSystem fs) throws Exception {
                    Path filepath = new Path(new URI(stringIRI));
                    if (!fs.isFile(filepath)) {
                        throw new ProviderException(ProviderErrorCode.ResourceNotFound, uri);
                    }
                    FileStatus fstats = fs.getFileStatus(filepath);
                    boolean isWritable = fstats.getPermission().getUserAction().implies(FsAction.WRITE);
                    return new FileMetadata(filepath.toString(), fstats.getLen(), fstats.getModificationTime(), isWritable);
                }
            });
        }
        catch (Exception e) {
            throw new ProviderException(ProviderErrorCode.ResourceNotFound, uri);
        }
    }

    public FolderAttributes getFolderAttributes(final StorageURI uri) throws ProviderException {
        try {
            final String stringIRI = uri.toString();
            FilesystemCache.FilesystemTaskRunner tr = this.fs_cache_.getTaskRunnerForIRI(stringIRI);
            return tr.runTask(new FilesystemCache.FilesystemTask<FolderAttributes>(){

                @Override
                public FolderAttributes run(FileSystem fs) throws Exception {
                    Path filepath = new Path(new URI(stringIRI));
                    if (!fs.isDirectory(filepath)) {
                        throw new ProviderException(ProviderErrorCode.ResourceNotFound, uri);
                    }
                    FileStatus fstats = fs.getFileStatus(filepath);
                    boolean isWritable = fstats.getPermission().getUserAction().implies(FsAction.WRITE);
                    return new FolderMetadata(filepath.toString(), new Date(fstats.getModificationTime()), isWritable);
                }
            });
        }
        catch (Exception e) {
            throw new ProviderException(ProviderErrorCode.ResourceNotFound, uri);
        }
    }

    public ProviderChannel getReadOnlyChannel(final StorageURI uri) throws ProviderException {
        try {
            final String stringIRI = uri.toString();
            FilesystemCache.FilesystemTaskRunner tr = this.fs_cache_.getTaskRunnerForIRI(stringIRI);
            return tr.runTask(new FilesystemCache.FilesystemTask<ProviderChannel>(){

                @Override
                public ProviderChannel run(FileSystem fs) throws Exception {
                    Path filepath = new Path(new URI(stringIRI));
                    FSDataInputStream fis = fs.open(filepath);
                    FileStatus stats = fs.getFileStatus(filepath);
                    return HadoopProviderImpl.this.getReadOnlyChannel(fis, stats, uri);
                }
            });
        }
        catch (Exception e) {
            throw new ProviderException(ProviderErrorCode.ResourceNotFound, uri);
        }
    }

    public ProviderChannel getChannel(final StorageURI uri, final boolean create, boolean truncate, boolean append) throws ProviderException {
        try {
            final String stringIRI = uri.toString();
            FilesystemCache.FilesystemTaskRunner tr = this.fs_cache_.getTaskRunnerForIRI(stringIRI);
            return tr.runTask(new FilesystemCache.FilesystemTask<ProviderChannel>(){

                @Override
                public ProviderChannel run(FileSystem fs) throws Exception {
                    Path filepath = new Path(new URI(stringIRI));
                    if (!create && !fs.exists(filepath)) {
                        throw new ProviderException(ProviderErrorCode.ResourceNotFound, uri);
                    }
                    FSDataOutputStream fos = fs.create(filepath, true);
                    FileStatus stats = fs.getFileStatus(filepath);
                    return HadoopProviderImpl.this.getWritableChannel(fos, stats, uri);
                }
            });
        }
        catch (Exception e) {
            throw new ProviderException(ProviderErrorCode.ResourceNotFound, uri);
        }
    }

    public void moveFile(final StorageURI srcUri, final StorageURI dstUri, boolean overwrite) throws ProviderException {
        try {
            FilesystemCache.FilesystemTaskRunner tr = this.fs_cache_.getTaskRunnerForIRI(srcUri.toString());
            tr.runTask(new FilesystemCache.FilesystemTask<Object>(){

                @Override
                public Object run(FileSystem fs) throws Exception {
                    Path srcfilepath = new Path(new URI(srcUri.toString()));
                    Path dstfilepath = new Path(new URI(dstUri.toString()));
                    fs.rename(srcfilepath, dstfilepath);
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new ProviderException(ProviderErrorCode.ResourceNotFound, srcUri);
        }
    }

    public void moveFolder(StorageURI srcUri, StorageURI dstUri, boolean overwrite) throws ProviderException {
        this.moveFile(srcUri, dstUri, overwrite);
    }

    public void moveFile(StorageURI srcUri, StorageURI dstUri) throws ProviderException {
        this.moveFile(srcUri, dstUri, false);
    }

    public void moveFolder(StorageURI srcUri, StorageURI dstUri) throws ProviderException {
        this.moveFile(srcUri, dstUri);
    }

    public FolderListEntry[] listFolder(StorageURI uri) throws ProviderException {
        try {
            final String stringIRI = uri.toString();
            FilesystemCache.FilesystemTaskRunner tr = this.fs_cache_.getTaskRunnerForIRI(stringIRI);
            return tr.runTask(new FilesystemCache.FilesystemTask<FolderListEntry[]>(){

                @Override
                public FolderListEntry[] run(FileSystem fs) throws Exception {
                    Path folderpath = new Path(new URI(stringIRI));
                    FileStatus[] lFiles = fs.listStatus(folderpath);
                    FolderListEntry[] entries = new FolderListEntry[lFiles.length];
                    for (int i = 0; i < lFiles.length; ++i) {
                        String name = lFiles[i].getPath().getName();
                        boolean isWritable = lFiles[i].getPermission().getUserAction().implies(FsAction.WRITE);
                        entries[i] = lFiles[i].isDir() ? new FolderMetadata(name, new Date(lFiles[i].getModificationTime()), isWritable) : new FileMetadata(name, lFiles[i].getLen(), new Date(lFiles[i].getModificationTime()), isWritable);
                    }
                    return entries;
                }
            });
        }
        catch (Exception e) {
            throw new ProviderException(ProviderErrorCode.ResourceNotFound, uri);
        }
    }
}

