/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.shared.controllib.databrowser.editor;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabEvent;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.mlwidgets.array.MatlabArrayDTMenuBar;
import com.mathworks.mlwidgets.array.ValueEditorProvider;
import com.mathworks.mlwidgets.array.ValueMetaInfo;
import com.mathworks.mlwidgets.workspace.WorkspaceCommands;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.toolbox.shared.controllib.databrowser.editor.AggregatedComponents;
import com.mathworks.toolbox.shared.controllib.databrowser.editor.ValueEditorProviderRegistry;
import com.mathworks.toolbox.shared.controllib.databrowser.editor.ValueSummaryBar;
import com.mathworks.widgets.spreadsheet.format.FormatIdentifier;
import com.mathworks.widgets.spreadsheet.format.FormattableDisplay;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class ValuePanel
extends MJPanel
implements FormattableDisplay {
    private AggregatedComponents fAggregatedComponents = null;
    private JComponent fDesiredFocusOwner = null;
    private MatlabArrayDTMenuBar fMenuBar = null;
    private ValueSummaryBar fSummaryBar = null;
    private boolean fMotionOnEnter;
    private int fMotionOnEnterDirection;
    private boolean fEditable;
    private boolean fEditableParents = true;
    private String fVarName;
    private boolean fCleanupInitiated = false;
    private ValueMetaInfo fValueMetaInfo;
    private FormatIdentifier fFormat = FormatIdentifier.SHORT;
    private ActionListener fMenuBarActionListener = null;

    public ValuePanel(String string) {
        this(string, true);
    }

    ValuePanel(String string, boolean bl) {
        this.fVarName = string;
        this.setLayout(new BorderLayout());
        this.setBackground(Color.WHITE);
        this.setPreferredSize(new Dimension(380, 330));
        this.setMinimumSize(new Dimension(100, 100));
        this.fSummaryBar = new ValueSummaryBar(string);
        this.add((Component)((Object)this.fSummaryBar), "North");
    }

    public ValueSummaryBar getValueSummaryBar() {
        return this.fSummaryBar;
    }

    public ValueEditorProvider getProvider() {
        return this.fAggregatedComponents.getProvider();
    }

    public MJPanel getPanel() {
        return this;
    }

    public void removePanelFromParent() {
        Container container = this.getParent();
        if (container != null) {
            container.remove((Component)((Object)this));
            container.repaint();
        }
        this.cleanup();
    }

    public void setfValueMetaInfo(ValueMetaInfo valueMetaInfo) {
        this.fValueMetaInfo = valueMetaInfo;
    }

    public ValueMetaInfo getfValueMetaInfo() {
        return this.fValueMetaInfo;
    }

    public void requestFocus() {
        super.requestFocus();
        this.requestFocusInWindow();
    }

    public boolean requestFocusInWindow() {
        boolean bl = super.requestFocusInWindow();
        if (bl && this.fDesiredFocusOwner != null) {
            bl = this.fDesiredFocusOwner.requestFocusInWindow();
        }
        return bl;
    }

    public MatlabArrayDTMenuBar getMenuBar() {
        return this.fMenuBar;
    }

    public void addMenuBarActionListener(ActionListener actionListener) {
        this.fMenuBarActionListener = actionListener;
        if (this.fMenuBar != null) {
            this.fMenuBar.addActionListener(actionListener);
        }
    }

    public void removeMenuBarActionListener(ActionListener actionListener) {
        this.fMenuBarActionListener = null;
        if (this.fMenuBar != null) {
            this.fMenuBar.removeActionListener(actionListener);
        }
    }

    private void setMenuBar(MatlabArrayDTMenuBar matlabArrayDTMenuBar) {
        if (this.fMenuBar != null) {
            this.fMenuBar.removeActionListener(this.fMenuBarActionListener);
        }
        if (matlabArrayDTMenuBar != null) {
            matlabArrayDTMenuBar.addActionListener(this.fMenuBarActionListener);
        }
        this.fMenuBar = matlabArrayDTMenuBar;
        if (this.fMenuBar != null) {
            this.fMenuBar.fireMenuBarChangedEvent();
        }
    }

    public void refreshViewer() {
        ValueEditorProvider valueEditorProvider = this.fAggregatedComponents == null ? null : this.fAggregatedComponents.getProvider();
        this.useOrRefreshViewer(this.setupAGFromProvider(ValueEditorProviderRegistry.getValueEditorProvider(this.fVarName, this.fValueMetaInfo, valueEditorProvider), valueEditorProvider));
    }

    private void useOrRefreshViewer(AggregatedComponents aggregatedComponents) {
        AggregatedComponents aggregatedComponents2 = this.fAggregatedComponents;
        this.setAggregatedComponents(aggregatedComponents);
        if (!aggregatedComponents.equals(aggregatedComponents2)) {
            ContentsReplacer contentsReplacer = new ContentsReplacer(aggregatedComponents, aggregatedComponents2);
            if (SwingUtilities.isEventDispatchThread()) {
                contentsReplacer.run();
            } else {
                SwingUtilities.invokeLater(contentsReplacer);
            }
        } else {
            this.refreshData(aggregatedComponents);
        }
    }

    private AggregatedComponents setupAGFromProvider(ValueEditorProvider valueEditorProvider, ValueEditorProvider valueEditorProvider2) {
        if (valueEditorProvider2 != null && valueEditorProvider2.equals(valueEditorProvider)) {
            return this.fAggregatedComponents;
        }
        AggregatedComponents aggregatedComponents = new AggregatedComponents(valueEditorProvider, this, this.fVarName);
        aggregatedComponents.setFont(this.getFont());
        aggregatedComponents.setForeground(this.getForeground());
        aggregatedComponents.setBackground(this.getBackground());
        aggregatedComponents.setMotionOnEnterDirection(this.getMotionOnEnterDirection());
        aggregatedComponents.setMotionOnEnter(this.isMotionOnEnter());
        aggregatedComponents.setEditable(this.fEditable && this.fEditableParents);
        aggregatedComponents.setFormat(this.fFormat);
        this.setMenuBar(aggregatedComponents.getMenuBar());
        this.updateReadOnlyStatus();
        return aggregatedComponents;
    }

    private void refreshData(AggregatedComponents aggregatedComponents) {
        if (aggregatedComponents != null) {
            aggregatedComponents.getProvider().updateData();
            this.updateReadOnlyStatus();
        }
    }

    private void updateReadOnlyStatus() {
        WorkspaceCommands.isParentIdentifierHierarchyReadOnly((List)WorkspaceCommands.getParentIdentifierHierarchy((String)this.fVarName), (MatlabListener)new ROML());
    }

    private void setAggregatedComponents(AggregatedComponents aggregatedComponents) {
        this.fAggregatedComponents = aggregatedComponents;
    }

    private void setHasROParent(boolean bl) {
        this.fEditableParents = !bl;
        this.setEditable(this.isEditable());
    }

    private void setDesiredFocusOwner(JComponent jComponent, boolean bl) {
        this.fDesiredFocusOwner = jComponent;
        if (jComponent != null && bl) {
            jComponent.requestFocus();
        }
    }

    public String getDesiredFocusOwnerName() {
        return this.fDesiredFocusOwner.getName();
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.fAggregatedComponents != null) {
            this.fAggregatedComponents.setForeground(color);
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.fAggregatedComponents != null) {
            this.fAggregatedComponents.setBackground(color);
        }
    }

    private static boolean anyChildHasFocus(Container container) {
        Component[] componentArray;
        if (container == null) {
            return false;
        }
        for (Component component : componentArray = container.getComponents()) {
            if (component.isFocusOwner()) {
                return true;
            }
            if (!(component instanceof Container) || !ValuePanel.anyChildHasFocus((Container)component)) continue;
            return true;
        }
        return false;
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.fAggregatedComponents != null) {
            this.fAggregatedComponents.setFont(font);
        }
    }

    public void setFormat(FormatIdentifier formatIdentifier) {
        this.fFormat = formatIdentifier;
        if (this.fAggregatedComponents != null) {
            this.fAggregatedComponents.setFormat(formatIdentifier);
        }
    }

    public FormatIdentifier getFormat() {
        return this.fFormat;
    }

    public int getMotionOnEnterDirection() {
        return this.fMotionOnEnterDirection;
    }

    public void setMotionOnEnterDirection(int n) {
        this.fMotionOnEnterDirection = n;
        if (this.fAggregatedComponents != null) {
            this.fAggregatedComponents.setMotionOnEnterDirection(n);
        }
    }

    public boolean isMotionOnEnter() {
        return this.fMotionOnEnter;
    }

    public void setMotionOnEnter(boolean bl) {
        this.fMotionOnEnter = bl;
        if (this.fAggregatedComponents != null) {
            this.fAggregatedComponents.setMotionOnEnter(bl);
        }
    }

    public void setEditable(boolean bl) {
        this.fEditable = bl;
        if (this.fAggregatedComponents != null) {
            this.fAggregatedComponents.setEditable(bl && this.fEditableParents);
        }
    }

    public boolean isEditable() {
        return this.fEditable;
    }

    public void cleanup() {
        FocusListener[] focusListenerArray;
        this.fCleanupInitiated = true;
        this.removeAll();
        this.fMenuBar.removeActionListener(this.fMenuBarActionListener);
        this.fMenuBarActionListener = null;
        this.fMenuBar = null;
        if (this.fSummaryBar != null) {
            this.fSummaryBar = null;
        }
        if (this.fAggregatedComponents != null) {
            this.fAggregatedComponents.cleanup();
        }
        this.fAggregatedComponents = null;
        for (FocusListener focusListener : focusListenerArray = this.getFocusListeners()) {
            this.removeFocusListener(focusListener);
        }
    }

    public boolean isCleanupInitiated() {
        return this.fCleanupInitiated;
    }

    private class ROML
    implements MatlabListener {
        private ROML() {
        }

        public void matlabEvent(MatlabEvent matlabEvent) {
            if (Matlab.getExecutionStatus((int)matlabEvent.getStatus()) != 0) {
                ValuePanel.this.setHasROParent(false);
            } else {
                boolean[] blArray = (boolean[])matlabEvent.getResult();
                ValuePanel.this.setHasROParent(blArray[0]);
            }
        }
    }

    private class ContentsReplacer
    implements Runnable {
        private AggregatedComponents iOldComponents;
        private AggregatedComponents iComponents;

        ContentsReplacer(AggregatedComponents aggregatedComponents, AggregatedComponents aggregatedComponents2) {
            this.iComponents = aggregatedComponents;
            this.iOldComponents = aggregatedComponents2;
        }

        @Override
        public void run() {
            if (this.iComponents != null) {
                boolean bl = ValuePanel.anyChildHasFocus(ValuePanel.this.fDesiredFocusOwner);
                Component component = ((BorderLayout)ValuePanel.this.getLayout()).getLayoutComponent("Center");
                if (component != null) {
                    ValuePanel.this.remove(component);
                }
                if (this.iOldComponents != null) {
                    this.iOldComponents.cleanup();
                }
                JComponent jComponent = this.iComponents.getProvider().getComponent();
                ValuePanel.this.add(jComponent, "Center");
                ValuePanel.this.validate();
                ValuePanel.this.setDesiredFocusOwner(jComponent, bl);
            }
        }
    }
}

