/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.shared.controllib.guide;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mwswing.MJDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.Border;

public class ColorChooser
extends MJDialog {
    public static final Color[] sSupportedColors = new Color[]{Color.RED, new Color(255, 127, 0), new Color(255, 191, 0), Color.YELLOW, Color.GREEN, Color.BLUE, Color.WHITE, Color.BLACK};
    public static final String[] sColorNames = new String[]{"Color.Red", "Color.Orange", "Color.Amber", "Color.Yellow", "Color.Green", "Color.Blue", "Color.White", "Color.Black"};
    private Color fSelectedColor = null;
    private final List<JLabel> fLabels = new ArrayList<JLabel>();
    private final List<Color> fColors = Arrays.asList(sSupportedColors);
    private JPanel fPanel;
    private MouseHandler fMouseHandler;
    private static final long serialVersionUID = 1L;
    private final Border fSelectionBorder = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(239, 72, 16)), BorderFactory.createLineBorder(Color.WHITE));
    private final Border fNonSelectionBorder = BorderFactory.createLineBorder(Color.GRAY);
    private final Border fHighlightBorder = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.ORANGE), BorderFactory.createLineBorder(Color.WHITE));

    public ColorChooser(Frame frame, boolean bl) {
        super(frame, "Color Chooser", false);
        this.init(bl);
    }

    public ColorChooser(Dialog dialog, boolean bl) {
        super(dialog, "Color Chooser", false);
        this.init(bl);
    }

    private void init(boolean bl) {
        this.setUndecorated(true);
        this.setResizable(false);
        this.setAlwaysOnTop(true);
        this.setName("ColorChooser");
        this.setCloseOnEscapeEnabled(true);
        this.setDefaultCloseOperation(1);
        this.addWindowFocusListener(new WindowFocusHandler());
        this.fPanel = bl ? new JPanel((LayoutManager)new FormLayout("2dlu, f:12dlu, 2dlu, f:12dlu, 2dlu, f:12dlu, 2dlu, f:12dlu, 2dlu, f:12dlu, 2dlu, f:12dlu, 2dlu, f:12dlu, 2dlu", "2dlu, f:12dlu, 2dlu, f:p, 2dlu, f:12dlu, 2dlu")) : new JPanel((LayoutManager)new FormLayout("2dlu, f:12dlu, 2dlu, f:12dlu, 2dlu, f:12dlu, 2dlu, f:12dlu, 2dlu, f:12dlu, 2dlu, f:12dlu, 2dlu", "2dlu, f:12dlu, 2dlu"));
        this.fPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.fMouseHandler = new MouseHandler();
        CellConstraints cellConstraints = new CellConstraints();
        int n = bl ? this.fColors.size() : this.fColors.size() - 2;
        for (int i = 0; i < n; ++i) {
            this.fLabels.add(new JLabel());
            this.fLabels.get(i).setName(sColorNames[i]);
            this.fLabels.get(i).addMouseListener(this.fMouseHandler);
            this.fLabels.get(i).setOpaque(true);
            this.fLabels.get(i).setBackground(this.fColors.get(i));
            this.fLabels.get(i).setBorder(this.fNonSelectionBorder);
            if (i < this.fColors.size() - 1) {
                this.fPanel.add((Component)this.fLabels.get(i), cellConstraints.rc(2, 2 * i + 2));
                continue;
            }
            this.fPanel.add((Component)new JSeparator(), cellConstraints.rchw(4, 2, 1, 13));
            this.fPanel.add((Component)this.fLabels.get(i), cellConstraints.rc(6, 2));
        }
        if (bl) {
            this.setSelectedColor(this.fColors.get(this.fColors.size() - 1));
        } else {
            this.setSelectedColor(this.fColors.get(0));
        }
        this.setLayout(new BorderLayout());
        this.add(this.fPanel, "Center");
        this.pack();
    }

    public Color getSelectedColor() {
        return this.fSelectedColor;
    }

    public void setSelectedColor(Color color) {
        int n = this.fColors.indexOf(this.fSelectedColor);
        if (n > -1) {
            this.fLabels.get(n).setBorder(this.fNonSelectionBorder);
        }
        this.fSelectedColor = color;
        n = this.fColors.indexOf(this.fSelectedColor);
        if (n > -1) {
            this.fLabels.get(n).setBorder(this.fSelectionBorder);
        }
        this.fPanel.revalidate();
        this.fPanel.repaint();
    }

    private class WindowFocusHandler
    extends WindowAdapter {
        private WindowFocusHandler() {
        }

        @Override
        public void windowLostFocus(WindowEvent windowEvent) {
            ColorChooser.this.setVisible(false);
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private Color fCurrentColor = null;

        private MouseHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            int n = ColorChooser.this.fLabels.indexOf(mouseEvent.getComponent());
            this.fCurrentColor = (Color)ColorChooser.this.fColors.get(n);
            ((JLabel)ColorChooser.this.fLabels.get(n)).setBorder(ColorChooser.this.fHighlightBorder);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            int n = ColorChooser.this.fLabels.indexOf(mouseEvent.getComponent());
            this.fCurrentColor = null;
            if (n == ColorChooser.this.fColors.indexOf(ColorChooser.this.getSelectedColor())) {
                ((JLabel)ColorChooser.this.fLabels.get(n)).setBorder(ColorChooser.this.fSelectionBorder);
            } else {
                ((JLabel)ColorChooser.this.fLabels.get(n)).setBorder(ColorChooser.this.fNonSelectionBorder);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.fCurrentColor != null) {
                ColorChooser.this.setSelectedColor(this.fCurrentColor);
                ColorChooser.this.setVisible(false);
            }
        }
    }
}

