/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html;

import com.mathworks.html.CustomProtocolUrl;
import com.mathworks.html.FileUrl;
import com.mathworks.html.RelativeUrl;
import com.mathworks.html.Url;
import com.mathworks.html.UrlTransformer;
import com.mathworks.html.WebUrl;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ChildUrlRelativizer {
    private final UrlTransformer<RelativeUrl> fTransformer;

    public ChildUrlRelativizer(Url url) {
        this.fTransformer = (UrlTransformer)new UrlTransformerFactory().transformUrl(url);
    }

    public RelativeUrl getRelativeUrlTo(Url url) {
        return this.fTransformer == null ? null : this.fTransformer.transformUrl(url);
    }

    public boolean isChild(Url url) {
        return this.getRelativeUrlTo(url) != null;
    }

    private static boolean doDomainsMatch(WebUrl webUrl, WebUrl webUrl2) {
        URL uRL = webUrl.toURL();
        URL uRL2 = webUrl2.toURL();
        return uRL.getProtocol().equals(uRL2.getProtocol()) && uRL.getHost().equals(uRL2.getHost()) && uRL.getPort() == uRL2.getPort();
    }

    private static class WebUrlRelativizer
    extends BaseUrlRelativizer<WebUrl> {
        private WebUrlRelativizer(WebUrl webUrl) {
            super(webUrl, null);
        }

        @Override
        protected RelativeUrl transformWebUrl(WebUrl webUrl) {
            WebUrl webUrl2 = (WebUrl)this.getParentUrl();
            if (ChildUrlRelativizer.doDomainsMatch(webUrl2, webUrl)) {
                String[] stringArray;
                String[] stringArray2 = webUrl2.getPathParts();
                if (stringArray2.length > (stringArray = webUrl.getPathParts()).length) {
                    return null;
                }
                for (int i = 0; i < stringArray2.length; ++i) {
                    if (stringArray2[i].equals(stringArray[i])) continue;
                    return null;
                }
                if (stringArray2.length == stringArray.length) {
                    return null;
                }
                String[] stringArray3 = Arrays.copyOfRange(stringArray, stringArray2.length, stringArray.length);
                String string = WebUrlRelativizer.toBaseRelativePath(stringArray3);
                return this.toRelativeUrl(string, webUrl);
            }
            return null;
        }

        private static String toBaseRelativePath(String[] stringArray) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : stringArray) {
                stringBuilder.append('/').append(string);
            }
            return stringBuilder.substring(1);
        }
    }

    private static class FileUrlRelativizer
    extends BaseUrlRelativizer<FileUrl> {
        FileUrlRelativizer(FileUrl fileUrl) {
            super(fileUrl, null);
        }

        @Override
        protected RelativeUrl transformFileUrl(FileUrl fileUrl) {
            File file = ((FileUrl)this.getParentUrl()).getFile();
            if (file.exists() && !file.isDirectory()) {
                file = file.getParentFile();
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (File file2 = fileUrl.getFile(); file2 != null; file2 = file2.getParentFile()) {
                if (file2.equals(file)) {
                    return this.toRelativeUrl(stringBuilder.toString(), fileUrl);
                }
                if (stringBuilder.length() > 0) {
                    stringBuilder.insert(0, '/');
                }
                stringBuilder.insert(0, file2.getName());
            }
            return null;
        }
    }

    private static class BaseUrlRelativizer<T extends Url>
    extends UrlTransformer<RelativeUrl> {
        private T iParentUrl;

        private BaseUrlRelativizer(T t) {
            this.iParentUrl = t;
        }

        protected T getParentUrl() {
            return this.iParentUrl;
        }

        @Override
        protected RelativeUrl transformWebUrl(WebUrl webUrl) {
            return null;
        }

        @Override
        protected RelativeUrl transformFileUrl(FileUrl fileUrl) {
            return null;
        }

        @Override
        protected RelativeUrl transformCustomProtocolUrl(CustomProtocolUrl customProtocolUrl) {
            return null;
        }

        protected RelativeUrl toRelativeUrl(String string, Url url) {
            Map<String, List<String>> map = this.removeParametersFromBase(url);
            String string2 = this.getChildTarget(url);
            return new RelativeUrl(string, map, string2);
        }

        private Map<String, List<String>> removeParametersFromBase(Url url) {
            LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>(url.getParameters());
            Map<String, List<String>> map = ((Url)this.iParentUrl).getParameters();
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                ArrayList arrayList = (ArrayList)linkedHashMap.get(entry.getKey());
                if (arrayList == null || arrayList.isEmpty()) continue;
                arrayList = new ArrayList(arrayList);
                arrayList.removeAll((Collection)entry.getValue());
                if (arrayList.isEmpty()) {
                    linkedHashMap.remove(entry.getKey());
                    continue;
                }
                linkedHashMap.put(entry.getKey(), arrayList);
            }
            return linkedHashMap;
        }

        private String getChildTarget(Url url) {
            String string = url.getTarget();
            if (string != null) {
                String string2 = ((Url)this.iParentUrl).getTarget();
                return string.equals(string2) ? null : string;
            }
            return null;
        }

        /* synthetic */ BaseUrlRelativizer(Url url, 1 var2_2) {
            this(url);
        }
    }

    private static class UrlTransformerFactory
    extends UrlTransformer<UrlTransformer<RelativeUrl>> {
        private UrlTransformerFactory() {
        }

        @Override
        protected UrlTransformer<RelativeUrl> transformWebUrl(WebUrl webUrl) {
            return new WebUrlRelativizer(webUrl);
        }

        @Override
        protected UrlTransformer<RelativeUrl> transformFileUrl(FileUrl fileUrl) {
            return new FileUrlRelativizer(fileUrl);
        }

        @Override
        protected UrlTransformer<RelativeUrl> transformCustomProtocolUrl(CustomProtocolUrl customProtocolUrl) {
            return null;
        }
    }
}

