/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html;

import com.mathworks.html.ContextMenuTargetData;
import com.mathworks.html.HtmlActionGroup;
import com.mathworks.html.HtmlActionGroups;
import com.mathworks.html.HtmlActions;
import com.mathworks.html.HtmlContextMenuBuilder;
import com.mathworks.html.SelectedTextUtils;
import com.mathworks.html.StandardHtmlActionId;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JPopupMenu;

public class DefaultContextMenuBuilder
implements HtmlContextMenuBuilder {
    protected static final String NAV_ACTIONS = "NavActions";
    protected static final String FIND_ACTIONS = "FindActions";
    protected static final String COPY_ACTIONS = "CopyActions";
    protected static final String FILE_ACTIONS = "FileActions";
    protected static final String PAGE_ACTIONS = "PageActions";

    @Override
    public JPopupMenu buildContextMenu(HtmlActions htmlActions, ContextMenuTargetData contextMenuTargetData) {
        if (htmlActions != null) {
            HtmlActionGroups htmlActionGroups = this.getActionGroups(htmlActions, contextMenuTargetData);
            String string = contextMenuTargetData == null ? null : contextMenuTargetData.getSelectedText();
            return DefaultContextMenuBuilder.buildContextMenu(htmlActionGroups, string);
        }
        return null;
    }

    private static JPopupMenu buildContextMenu(HtmlActionGroups htmlActionGroups, String string) {
        Collection<HtmlActionGroup> collection = htmlActionGroups.getAllGroups();
        if (!collection.isEmpty()) {
            JPopupMenu jPopupMenu = DefaultContextMenuBuilder.createEmptyPopupMenu();
            for (HtmlActionGroup htmlActionGroup : collection) {
                Map<String, Action> map = htmlActionGroup.getAllActions();
                if (map == null || map.isEmpty()) continue;
                DefaultContextMenuBuilder.addAsGroup(jPopupMenu, htmlActionGroup.getAllActions().values());
            }
            if (string != null) {
                SelectedTextUtils.setSelectedTextForContextMenu(jPopupMenu, string);
            }
            return jPopupMenu;
        }
        return null;
    }

    protected static void addAsGroup(JPopupMenu jPopupMenu, Collection<? extends Action> collection) {
        if (jPopupMenu.getSubElements().length > 0) {
            jPopupMenu.addSeparator();
        }
        for (Action action : collection) {
            jPopupMenu.add(action);
        }
    }

    protected HtmlActionGroups getActionGroups(HtmlActions htmlActions, ContextMenuTargetData contextMenuTargetData) {
        HtmlActionGroups htmlActionGroups = new HtmlActionGroups();
        HtmlActionGroups htmlActionGroups2 = htmlActions.getCustomActionGroups();
        if (htmlActionGroups2 != null) {
            htmlActionGroups.addAllCustomActionGroups(htmlActionGroups2);
        }
        HtmlActionGroup htmlActionGroup = this.createNavActionGroup(htmlActions);
        htmlActionGroups.addCustomActionGroup(htmlActionGroup);
        HtmlActionGroup htmlActionGroup2 = this.createFindActionGroup(htmlActions);
        htmlActionGroups.addCustomActionGroup(htmlActionGroup2);
        HtmlActionGroup htmlActionGroup3 = this.createPageActionGroup(htmlActions);
        htmlActionGroups.addCustomActionGroup(htmlActionGroup3);
        return htmlActionGroups;
    }

    protected HtmlActionGroup createNavActionGroup(HtmlActions htmlActions) {
        Map<String, ? extends Action> map = DefaultContextMenuBuilder.createActionGroup(htmlActions, StandardHtmlActionId.GO_BACK, StandardHtmlActionId.GO_FORWARD, StandardHtmlActionId.RELOAD);
        return map == null ? null : new HtmlActionGroup(NAV_ACTIONS, map);
    }

    protected HtmlActionGroup createFindActionGroup(HtmlActions htmlActions) {
        Map<String, ? extends Action> map = DefaultContextMenuBuilder.createActionGroup(htmlActions, StandardHtmlActionId.FIND);
        return map == null ? null : new HtmlActionGroup(FIND_ACTIONS, map);
    }

    protected HtmlActionGroup createPageActionGroup(HtmlActions htmlActions) {
        Map<String, ? extends Action> map = DefaultContextMenuBuilder.createActionGroup(htmlActions, StandardHtmlActionId.VIEW_SOURCE);
        return map == null ? null : new HtmlActionGroup(PAGE_ACTIONS, map);
    }

    protected static Map<String, ? extends Action> createActionGroup(HtmlActions htmlActions, StandardHtmlActionId ... standardHtmlActionIdArray) {
        Map<StandardHtmlActionId, ? extends Action> map = htmlActions.getBasicActions();
        if (map == null || map.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, Action> linkedHashMap = new LinkedHashMap<String, Action>();
        for (StandardHtmlActionId standardHtmlActionId : standardHtmlActionIdArray) {
            Action action = map.get((Object)standardHtmlActionId);
            if (action == null) continue;
            linkedHashMap.put(standardHtmlActionId.toString(), action);
        }
        return linkedHashMap;
    }

    private static JPopupMenu createEmptyPopupMenu() {
        return new JPopupMenu();
    }
}

