/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html;

import com.mathworks.html.BasicHtmlActionStateManager;
import com.mathworks.html.BrowserListeners;
import com.mathworks.html.DefaultContextMenuBuilder;
import com.mathworks.html.FileExtensionHandler;
import com.mathworks.html.FindOption;
import com.mathworks.html.HtmlActionGroups;
import com.mathworks.html.HtmlActionStateManager;
import com.mathworks.html.HtmlActions;
import com.mathworks.html.HtmlComponent;
import com.mathworks.html.HtmlComponentIdentifier;
import com.mathworks.html.HtmlContextMenuBuilder;
import com.mathworks.html.HtmlDataListener;
import com.mathworks.html.HtmlFindInPage;
import com.mathworks.html.HtmlPanelContextMenuHandler;
import com.mathworks.html.HtmlPanelSupport;
import com.mathworks.html.HtmlPanelSupportFactory;
import com.mathworks.html.HtmlUtils;
import com.mathworks.html.LoadFailureHandlerMap;
import com.mathworks.html.PageChangedEvent;
import com.mathworks.html.PageChangedListener;
import com.mathworks.html.PopupWindowListener;
import com.mathworks.html.RequestHandler;
import com.mathworks.html.SelectedTextUtils;
import com.mathworks.html.StatusTextListener;
import com.mathworks.html.Url;
import com.mathworks.html.jxbrowser.JxBrowserFactory;
import com.mathworks.html.jxbrowser.chromium.JxBrowserChromiumFactory;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public final class HtmlPanel
implements HtmlComponent {
    private static File sResourceDir;
    private final HtmlPanelSupport fSupport;
    private final List<HtmlActionStateManager> fStateManagers = new LinkedList<HtmlActionStateManager>();
    private final BrowserListeners fBrowserListeners = new BrowserListeners();
    private HtmlActions fActions;
    private String fHomeUrl = null;
    private HtmlContextMenuBuilder fHtmlContextMenuBuilder;
    private boolean fNavigationEnabled = true;

    public HtmlPanel() {
        this(BrowserType.JXBROWSER);
    }

    public HtmlPanel(BrowserType browserType) {
        this(HtmlPanel.getImplementorFactory(browserType));
    }

    public HtmlPanel(final HtmlPanelSupportFactory htmlPanelSupportFactory) {
        this.fSupport = htmlPanelSupportFactory.buildSupport(this.fBrowserListeners);
        this.fSupport.setContextMenuHandler(new HtmlPanelContextMenuHandler(this));
        this.addRequestHandler(new FileExtensionHandler("pdf", "doc", "docx", "c", "cpp"));
        this.fHtmlContextMenuBuilder = new DefaultContextMenuBuilder();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                htmlPanelSupportFactory.doWhenPanelCreated(new UpdateActionStatesListener());
            }
        });
    }

    private void updateActionStates() {
        HtmlActions htmlActions = this.getActions();
        if (htmlActions != null) {
            for (HtmlActionStateManager htmlActionStateManager : this.fStateManagers) {
                htmlActionStateManager.updateActionStates(htmlActions);
            }
        }
    }

    private static HtmlPanelSupportFactory getImplementorFactory(BrowserType browserType) {
        switch (browserType) {
            case CHROMIUM: {
                return new JxBrowserChromiumFactory();
            }
        }
        return new JxBrowserFactory();
    }

    public BrowserType getBrowserType() {
        return this.fSupport.getBrowserType();
    }

    @Override
    public JComponent getComponent() {
        return this.fSupport.getComponent();
    }

    @Override
    public boolean isInitialized() {
        return this.fSupport.isInitialized();
    }

    @Override
    public void setCurrentLocation(String string) {
        try {
            this.setCurrentLocation(Url.parse(string));
        }
        catch (MalformedURLException malformedURLException) {
            this.fSupport.getNavigator().setCurrentLocation(HtmlUtils.correctUrl(string));
        }
    }

    @Override
    public void setCurrentLocation(Url url) {
        this.fSupport.getNavigator().setCurrentLocation(url);
    }

    @Override
    public void setHtmlText(String string) {
        if (string != null) {
            this.fSupport.getNavigator().setHtmlText(string);
        }
    }

    @Override
    public String getCurrentLocation() {
        Url url = this.fSupport.getNavigator().getCurrentLocation();
        return url == null ? "" : url.toString();
    }

    @Override
    public String getTitle() {
        return this.fSupport.getTitle();
    }

    @Override
    public void executeScript(String string) {
        this.executeScript(string, null);
    }

    @Override
    public void executeScript(String string, HtmlDataListener<String> htmlDataListener) {
        this.fSupport.executeScript(string, htmlDataListener);
    }

    @Override
    public boolean canGoBack() {
        return this.fNavigationEnabled && this.fSupport.getNavigator().canGoBack();
    }

    @Override
    public void goBack() {
        if (this.fNavigationEnabled) {
            this.fSupport.getNavigator().goBack();
        }
    }

    @Override
    public boolean canGoForward() {
        return this.fNavigationEnabled && this.fSupport.getNavigator().canGoForward();
    }

    @Override
    public void goForward() {
        if (this.fNavigationEnabled) {
            this.fSupport.getNavigator().goForward();
        }
    }

    @Override
    public void reload() {
        if (this.fNavigationEnabled) {
            this.fSupport.getNavigator().reload();
        }
    }

    public void setHomeUrl(String string) {
        this.fHomeUrl = string;
    }

    @Override
    public String getHomeUrl() {
        return this.fHomeUrl;
    }

    @Override
    public void getSelectedText(final HtmlDataListener<String> htmlDataListener) {
        HtmlDataListener<String> htmlDataListener2 = new HtmlDataListener<String>(){

            @Override
            public void dataRetrieved(String string) {
                String string2 = SelectedTextUtils.correctSelectedTextWhitespace(string);
                htmlDataListener.dataRetrieved(string2);
            }
        };
        this.fSupport.getSelectedText(htmlDataListener2);
    }

    @Override
    public String getHtmlText() {
        return this.fSupport.getHtmlText();
    }

    @Override
    public boolean isPrintingSupported() {
        return this.fSupport.isPrintingSupported();
    }

    @Override
    public void print(HtmlDataListener<Boolean> htmlDataListener) {
        this.fSupport.print(htmlDataListener);
    }

    @Override
    public void saveAs(File file) {
        this.fSupport.saveAs(file);
    }

    @Override
    public void dispose() {
        this.fSupport.dispose();
        if (this.fActions != null) {
            this.fActions.dispose();
        }
    }

    @Override
    public void addPageChangedListener(PageChangedListener pageChangedListener) {
        this.fBrowserListeners.getPageChangedListener().addListener(pageChangedListener);
    }

    @Override
    public void removePageChangedListener(PageChangedListener pageChangedListener) {
        this.fBrowserListeners.getPageChangedListener().removeListener(pageChangedListener);
    }

    @Override
    public void addStatusTextListener(StatusTextListener statusTextListener) {
        this.fBrowserListeners.getStatusTextListener().addListener(statusTextListener);
    }

    @Override
    public void removeStatusTextListener(StatusTextListener statusTextListener) {
        this.fBrowserListeners.getStatusTextListener().removeListener(statusTextListener);
    }

    @Override
    public void addTitleChangedListener(HtmlDataListener<String> htmlDataListener) {
        this.fBrowserListeners.getTitleListener().addListener(htmlDataListener);
    }

    @Override
    public void removeTitleChangedListener(HtmlDataListener<String> htmlDataListener) {
        this.fBrowserListeners.getTitleListener().removeListener(htmlDataListener);
    }

    @Override
    public void disableNavigation() {
        this.fNavigationEnabled = false;
        if (this.fActions != null) {
            this.fActions.removeNavigationActions();
        }
    }

    public void addRequestHandler(RequestHandler requestHandler) {
        this.fBrowserListeners.getRequestHandler().addRequestHandler(requestHandler);
    }

    public void setActions(HtmlActions htmlActions) {
        if (!this.fNavigationEnabled && htmlActions != null) {
            htmlActions.removeNavigationActions();
        }
        this.fActions = htmlActions;
    }

    @Override
    public HtmlActions getActions() {
        return this.fActions;
    }

    @Override
    public HtmlActionGroups getBrowserSuppliedActions() {
        return this.fSupport.getBrowserSuppliedActions();
    }

    public HtmlContextMenuBuilder getContextMenuBuilder() {
        return this.fHtmlContextMenuBuilder;
    }

    public void setHtmlContextMenuBuilder(HtmlContextMenuBuilder htmlContextMenuBuilder) {
        this.fHtmlContextMenuBuilder = htmlContextMenuBuilder;
    }

    @Override
    public void findInPage(String string, Collection<FindOption> collection, HtmlDataListener<Boolean> htmlDataListener) {
        HtmlFindInPage htmlFindInPage = this.fSupport.getFindInPage();
        htmlFindInPage.find(string, collection, htmlDataListener);
    }

    public void addHtmlActionStateManager(HtmlActionStateManager htmlActionStateManager) {
        this.fStateManagers.add(htmlActionStateManager);
    }

    public static synchronized void setResourceDirectory(File file) {
        sResourceDir = file;
    }

    public static synchronized File getResourceDirectory() {
        if (sResourceDir == null) {
            try {
                sResourceDir = Files.createTempDirectory("htmlpanel", new FileAttribute[0]).toFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return sResourceDir;
    }

    public void setPopupWindowListener(PopupWindowListener popupWindowListener) {
        this.fSupport.setPopupWindowListener(popupWindowListener);
    }

    @Override
    public void addLoadFailureHandlers(LoadFailureHandlerMap loadFailureHandlerMap) {
        this.fSupport.getNavigator().addLoadFailureHandlers(loadFailureHandlerMap);
    }

    @Override
    public HtmlComponentIdentifier getId() {
        return this.fSupport.getId();
    }

    private class UpdateActionStatesListener
    implements HtmlPanelSupportFactory.ComponentCreatedListener {
        private UpdateActionStatesListener() {
        }

        @Override
        public void panelCreated(Component component) {
            HtmlPanel.this.fStateManagers.add(new BasicHtmlActionStateManager(HtmlPanel.this));
            HtmlPanel.this.addPageChangedListener(new PageChangedListener(){

                @Override
                public void pageChanged(PageChangedEvent pageChangedEvent) {
                    HtmlPanel.this.updateActionStates();
                }
            });
        }
    }

    public static enum BrowserType {
        JXBROWSER,
        CHROMIUM;

    }
}

