/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html;

import com.mathworks.html.Url;
import com.mathworks.html.UrlPartParser;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class RelativeUrl {
    private final String fRelativePath;
    private final Map<String, List<String>> fParameters = new LinkedHashMap<String, List<String>>();
    private final String fTarget;

    public RelativeUrl(String string, Map<String, List<String>> map, String string2) {
        this.fRelativePath = string;
        this.fParameters.putAll(map);
        this.fTarget = string2;
    }

    public static RelativeUrl fromString(String string) {
        UrlPartParser<RelativeUrl> urlPartParser = new UrlPartParser<RelativeUrl>(){

            @Override
            protected RelativeUrl buildUrl(String string, Map<String, List<String>> map, String string2) {
                return new RelativeUrl(string, map, string2);
            }
        };
        try {
            return (RelativeUrl)urlPartParser.parseUrlParts(string);
        }
        catch (MalformedURLException malformedURLException) {
            return new RelativeUrl(string, Collections.emptyMap(), null);
        }
    }

    public String getRelativePath() {
        return this.fRelativePath.replaceFirst(";.*", "");
    }

    public Map<String, List<String>> getParameters() {
        return Collections.unmodifiableMap(this.fParameters);
    }

    public String getTarget() {
        return this.fTarget;
    }

    public String toString() {
        return Url.assembleUrl(this.fRelativePath, this.fParameters, this.fTarget);
    }
}

