/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html;

import com.mathworks.html.CloneableUrl;
import com.mathworks.html.FileUrl;
import com.mathworks.html.RelativeUrl;
import com.mathworks.html.Url;
import com.mathworks.html.UrlBuilderFactory;
import com.mathworks.html.UrlParser;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UrlBuilder<T extends Url> {
    private CloneableUrl<T> fBaseUrl;
    private final Map<String, List<String>> fParameters = new LinkedHashMap<String, List<String>>();
    private String fTarget;

    public UrlBuilder(CloneableUrl<T> cloneableUrl) {
        this.fBaseUrl = cloneableUrl;
        this.fParameters.putAll(cloneableUrl.getParameters());
        this.fTarget = cloneableUrl.getTarget();
    }

    public static UrlBuilder<FileUrl> fromFile(File file) {
        return new FileUrl(file).toUrlBuilder();
    }

    public static UrlBuilder<? extends Url> fromURL(URL uRL) {
        return UrlParser.parse(uRL).toUrlBuilder();
    }

    public static UrlBuilder<? extends Url> fromString(String string) throws MalformedURLException {
        return UrlParser.parseToUrlBuilder(string);
    }

    public static <T extends Url> UrlBuilder<T> fromUrl(T t) {
        return UrlBuilderFactory.toUrlBuilder(t);
    }

    public UrlBuilder<T> append(String ... stringArray) {
        this.fBaseUrl = this.fBaseUrl.append(stringArray);
        UrlParser.addParameters(this.fParameters, this.fBaseUrl.getParameters());
        if (this.fBaseUrl.getTarget() != null) {
            this.setTarget(this.fBaseUrl.getTarget());
        }
        return this;
    }

    public UrlBuilder<T> append(RelativeUrl relativeUrl) {
        this.fBaseUrl = this.fBaseUrl.append(relativeUrl.getRelativePath());
        UrlParser.addParameters(this.fParameters, relativeUrl.getParameters());
        if (relativeUrl.getTarget() != null) {
            this.setTarget(relativeUrl.getTarget());
        }
        return this;
    }

    public UrlBuilder<T> removeParameter(String string) {
        this.fParameters.remove(string);
        return this;
    }

    public UrlBuilder<T> addParameter(String string, String ... stringArray) {
        return this.addParameter(string, Arrays.asList(stringArray));
    }

    public UrlBuilder<T> addParameter(String string, List<String> list) {
        UrlParser.addParameter(this.fParameters, string, list);
        return this;
    }

    public UrlBuilder<T> addParameters(Map<String, List<String>> map) {
        UrlBuilder<T> urlBuilder = this;
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            urlBuilder = this.addParameter(entry.getKey(), entry.getValue());
        }
        return urlBuilder;
    }

    public UrlBuilder<T> setParameter(String string, String ... stringArray) {
        return this.setParameter(string, Arrays.asList(stringArray));
    }

    public UrlBuilder<T> setParameter(String string, List<String> list) {
        this.fParameters.put(string, new ArrayList<String>(list));
        return this;
    }

    public UrlBuilder<T> setParameters(Map<String, List<String>> map) {
        this.fParameters.clear();
        this.fParameters.putAll(map);
        return this;
    }

    public UrlBuilder<T> setTarget(String string) {
        this.fTarget = string;
        return this;
    }

    public UrlBuilder<T> rewrite(T t) {
        return this.rewrite(t, EnumSet.allOf(Url.UrlPart.class));
    }

    public UrlBuilder<T> rewrite(T t, Set<Url.UrlPart> set) {
        return this.rewrite(UrlBuilder.fromUrl(t), set);
    }

    public UrlBuilder<T> rewrite(UrlBuilder<T> urlBuilder) {
        return this.rewrite(urlBuilder, (Set<Url.UrlPart>)EnumSet.allOf(Url.UrlPart.class));
    }

    public UrlBuilder<T> rewrite(UrlBuilder<T> urlBuilder, Set<Url.UrlPart> set) {
        if (set.contains((Object)Url.UrlPart.BASE)) {
            this.fBaseUrl = urlBuilder.fBaseUrl;
        }
        if (set.contains((Object)Url.UrlPart.QUERYSTRING)) {
            this.fParameters.clear();
            this.fParameters.putAll(urlBuilder.fParameters);
        }
        if (set.contains((Object)Url.UrlPart.TARGET)) {
            this.fTarget = urlBuilder.fTarget;
        }
        return this;
    }

    public T toUrl() {
        return this.fBaseUrl.createModifiedCopy(this.fParameters, this.fTarget);
    }

    public Url.UrlType getType() {
        return this.fBaseUrl.getType();
    }

    public String toString() {
        return ((Url)this.toUrl()).toString();
    }
}

