/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser;

import com.mathworks.html.HtmlDataListener;
import com.mathworks.html.jxbrowser.JxBrowserPanel;
import com.mathworks.html.jxbrowser.PrintStrategy;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class CompoundPrintStrategy
implements PrintStrategy {
    private final List<PrintStrategy> fStrategies;

    public CompoundPrintStrategy(PrintStrategy ... printStrategyArray) {
        this.fStrategies = Arrays.asList(printStrategyArray);
    }

    @Override
    public void print(JxBrowserPanel jxBrowserPanel, HtmlDataListener<Boolean> htmlDataListener) {
        new PrintStrategyChain(jxBrowserPanel, htmlDataListener).tryNextStrategy();
    }

    @Override
    public void dispose() {
        for (PrintStrategy printStrategy : this.fStrategies) {
            printStrategy.dispose();
        }
    }

    private class PrintStrategyChain
    implements HtmlDataListener<Boolean> {
        private final Iterator<PrintStrategy> iStrategiesIterator;
        private final JxBrowserPanel iPanel;
        private final HtmlDataListener<Boolean> iRealListener;

        private PrintStrategyChain(JxBrowserPanel jxBrowserPanel, HtmlDataListener<Boolean> htmlDataListener) {
            this.iStrategiesIterator = CompoundPrintStrategy.this.fStrategies.iterator();
            this.iPanel = jxBrowserPanel;
            this.iRealListener = htmlDataListener;
        }

        @Override
        public void dataRetrieved(Boolean bl) {
            if (bl.booleanValue()) {
                this.iRealListener.dataRetrieved(true);
            } else {
                this.tryNextStrategy();
            }
        }

        private void tryNextStrategy() {
            if (this.iStrategiesIterator.hasNext()) {
                PrintStrategy printStrategy = this.iStrategiesIterator.next();
                printStrategy.print(this.iPanel, this);
            } else {
                this.iRealListener.dataRetrieved(false);
            }
        }
    }
}

