/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser;

import com.mathworks.html.BrowserListeners;
import com.mathworks.html.BrowserQueue;
import com.mathworks.html.HtmlPanel;
import com.mathworks.html.jxbrowser.AggregateNewWindowManager;
import com.mathworks.html.jxbrowser.AggregateWebPolicyDelegate;
import com.mathworks.html.jxbrowser.BrowserConfig;
import com.mathworks.html.jxbrowser.BrowserHolder;
import com.mathworks.html.jxbrowser.DeferredBrowserSetup;
import com.mathworks.html.jxbrowser.JxBrowserSwingComponent;
import com.mathworks.html.jxbrowser.MWPromptService;
import com.mathworks.html.jxbrowser.QueuingBrowserHolder;
import com.mathworks.html.jxbrowser.RequestHandlerPolicyDelegate;
import com.mathworks.html.jxbrowser.StreamingTextHandler;
import com.mathworks.html.jxbrowser.TextSelectionScriptBuilder;
import com.teamdev.jxbrowser.Browser;
import com.teamdev.jxbrowser.BrowserServices;
import com.teamdev.jxbrowser.NewWindowManager;
import com.teamdev.jxbrowser.WebPolicyDelegate;
import com.teamdev.jxbrowser.prompt.PromptService;

class DefaultBrowserConfig
implements BrowserConfig {
    private static AggregateWebPolicyDelegate sSharedPolicyDelegate;
    private static AggregateNewWindowManager sSharedWindowManager;
    private final JxBrowserSwingComponent fComponent;
    private final BrowserListeners fListeners;
    private final StreamingTextHandler fStreamingTextHandler;
    private final RequestHandlerPolicyDelegate fPolicyDelegate;
    private final String fTextSelectionScript;
    private static boolean sInitializedOnce;

    static void initOnce() {
        BrowserServices browserServices;
        assert (BrowserQueue.isBrowserThread()) : "One-time browser initialization should be performed on the browser thread";
        if (!sInitializedOnce && (browserServices = BrowserServices.getInstance()) != null) {
            sSharedPolicyDelegate = new AggregateWebPolicyDelegate(browserServices.getWebPolicyDelegate());
            sSharedWindowManager = new AggregateNewWindowManager();
            PromptService promptService = browserServices.getPromptService();
            browserServices.setPromptService((PromptService)new MWPromptService(promptService));
            browserServices.setWebPolicyDelegate((WebPolicyDelegate)sSharedPolicyDelegate);
            browserServices.setNewWindowManager((NewWindowManager)sSharedWindowManager);
            sInitializedOnce = true;
        }
    }

    DefaultBrowserConfig(Browser browser, BrowserListeners browserListeners) {
        QueuingBrowserHolder queuingBrowserHolder = new QueuingBrowserHolder(browser);
        this.fComponent = DefaultBrowserConfig.createSwingComponent(queuingBrowserHolder);
        this.fListeners = browserListeners;
        this.fPolicyDelegate = new RequestHandlerPolicyDelegate(browserListeners.getRequestHandler());
        this.fTextSelectionScript = queuingBrowserHolder.invokeNow(new TextSelectionScriptBuilder());
        StreamingTextHandler streamingTextHandler = new StreamingTextHandler(queuingBrowserHolder);
        streamingTextHandler.setFileDir(HtmlPanel.getResourceDirectory());
        this.fStreamingTextHandler = streamingTextHandler;
    }

    private static JxBrowserSwingComponent createSwingComponent(BrowserHolder browserHolder) {
        JxBrowserSwingComponent jxBrowserSwingComponent = new JxBrowserSwingComponent(browserHolder);
        jxBrowserSwingComponent.addBrowserComponent();
        return jxBrowserSwingComponent;
    }

    @Override
    public void finishSetup() {
        BrowserHolder browserHolder = this.getSwingComponent().getBrowser();
        sSharedPolicyDelegate.addDelegate(browserHolder, this.getStreamingTextHandler());
        sSharedPolicyDelegate.addDelegate(browserHolder, this.getRequestHandlerPolicyDelegate());
        browserHolder.invokeLater(new DeferredBrowserSetup(this));
    }

    @Override
    public void disposeBrowser(boolean bl) {
        final BrowserHolder browserHolder = this.fComponent.getBrowser();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                DefaultBrowserConfig.this.fStreamingTextHandler.dispose();
                sSharedPolicyDelegate.clearBrowserDelegates(browserHolder);
                DefaultBrowserConfig.this.fComponent.dispose();
            }
        };
        browserHolder.disposeBrowser(runnable, bl);
    }

    @Override
    public JxBrowserSwingComponent getSwingComponent() {
        return this.fComponent;
    }

    @Override
    public StreamingTextHandler getStreamingTextHandler() {
        return this.fStreamingTextHandler;
    }

    @Override
    public AggregateNewWindowManager getNewWindowManager() {
        return sSharedWindowManager;
    }

    @Override
    public RequestHandlerPolicyDelegate getRequestHandlerPolicyDelegate() {
        return this.fPolicyDelegate;
    }

    @Override
    public BrowserListeners getBrowserListeners() {
        return this.fListeners;
    }

    @Override
    public String getTextSelectionScript() {
        return this.fTextSelectionScript;
    }

    static {
        sInitializedOnce = false;
    }
}

