/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser;

import com.mathworks.html.AggregatePageChangedListener;
import com.mathworks.html.BrowserListeners;
import com.mathworks.html.EncodingUtils;
import com.mathworks.html.HtmlDataListener;
import com.mathworks.html.StatusTextChangedEvent;
import com.mathworks.html.StatusTextListener;
import com.mathworks.html.Url;
import com.mathworks.html.jxbrowser.BrowserAccessRunnable;
import com.mathworks.html.jxbrowser.BrowserConfig;
import com.mathworks.html.jxbrowser.BrowserHolder;
import com.mathworks.html.jxbrowser.IEConfig;
import com.mathworks.html.jxbrowser.Mozilla15Config;
import com.mathworks.html.jxbrowser.MozillaConfig;
import com.mathworks.html.jxbrowser.NavigationFinishedListener;
import com.mathworks.html.jxbrowser.SafariConfig;
import com.mathworks.html.jxbrowser.StreamingTextHandler;
import com.teamdev.jxbrowser.Browser;
import com.teamdev.jxbrowser.events.NavigationEvent;
import com.teamdev.jxbrowser.events.NavigationFinishedEvent;
import com.teamdev.jxbrowser.events.NavigationListener;
import com.teamdev.jxbrowser.events.StatusChangedEvent;
import com.teamdev.jxbrowser.events.StatusListener;
import com.teamdev.jxbrowser.events.TitleChangedEvent;
import com.teamdev.jxbrowser.events.TitleListener;
import com.teamdev.jxbrowser.ie.IEBrowser;
import com.teamdev.jxbrowser.mozilla.MozillaBrowser;
import com.teamdev.jxbrowser.safari.SafariBrowser;

class DeferredBrowserSetup
implements BrowserAccessRunnable {
    private static boolean sFirstTime = true;
    private final BrowserConfig fBrowserSetup;

    DeferredBrowserSetup(BrowserConfig browserConfig) {
        this.fBrowserSetup = browserConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized boolean isFirstTime() {
        try {
            boolean bl = sFirstTime;
            return bl;
        }
        finally {
            sFirstTime = false;
        }
    }

    @Override
    public void handleMozillaBrowser(MozillaBrowser mozillaBrowser) {
        if (DeferredBrowserSetup.isFirstTime()) {
            MozillaConfig.initOnce();
        }
        this.doCommonBrowserSetup((Browser)mozillaBrowser);
    }

    @Override
    public void handleMozilla15Browser(com.teamdev.jxbrowser.mozilla15.MozillaBrowser mozillaBrowser) {
        if (DeferredBrowserSetup.isFirstTime()) {
            Mozilla15Config.initOnce();
        }
        this.doCommonBrowserSetup((Browser)mozillaBrowser);
    }

    @Override
    public void handleIEBrowser(IEBrowser iEBrowser) {
        new IEConfig(this.fBrowserSetup.getSwingComponent()).configureBrowser(iEBrowser);
        this.doCommonBrowserSetup((Browser)iEBrowser);
    }

    @Override
    public void handleSafariBrowser(SafariBrowser safariBrowser) {
        new SafariConfig(this.fBrowserSetup.getSwingComponent()).configureBrowser(safariBrowser);
        this.doCommonBrowserSetup((Browser)safariBrowser);
    }

    private void doCommonBrowserSetup(Browser browser) {
        BrowserHolder browserHolder = this.fBrowserSetup.getSwingComponent().getBrowser();
        StreamingTextHandler streamingTextHandler = this.fBrowserSetup.getStreamingTextHandler();
        BrowserListeners browserListeners = this.fBrowserSetup.getBrowserListeners();
        AggregatePageChangedListener aggregatePageChangedListener = browserListeners.getPageChangedListener();
        NavigationFinishedListener navigationFinishedListener = new NavigationFinishedListener(browserHolder, streamingTextHandler, aggregatePageChangedListener);
        browser.addNavigationListener((NavigationListener)navigationFinishedListener);
        browser.addStatusListener((StatusListener)new StatusTextListenerAdapter(browserListeners.getStatusTextListener()));
        TitleListenerAdapter titleListenerAdapter = new TitleListenerAdapter(browserListeners.getTitleListener());
        browser.addTitleListener((TitleListener)titleListenerAdapter);
        browser.addNavigationListener((NavigationListener)titleListenerAdapter);
        this.fBrowserSetup.getSwingComponent().initialize();
        browser.addNavigationListener((NavigationListener)this.fBrowserSetup.getRequestHandlerPolicyDelegate());
    }

    private static class TitleListenerAdapter
    implements TitleListener,
    NavigationListener {
        private Url iPage = null;
        private String iLastTitleForPage = null;
        private final HtmlDataListener<String> iTitleListener;

        private TitleListenerAdapter(HtmlDataListener<String> htmlDataListener) {
            this.iTitleListener = htmlDataListener;
        }

        public void titleChanged(TitleChangedEvent titleChangedEvent) {
            String string = titleChangedEvent.getTitle();
            if (!this.shouldRejectTitle(string)) {
                this.iLastTitleForPage = string;
                this.iTitleListener.dataRetrieved(string);
            }
        }

        private boolean shouldRejectTitle(String string) {
            return string == null || string.equals("about:blank") || this.iLastTitleForPage != null && this.iPage != null && this.iPage.getBaseUrl().endsWith(string);
        }

        public void navigationStarted(NavigationEvent navigationEvent) {
            Url url = Url.parseSilently(navigationEvent.getUrl());
            if (url != null && (this.iPage == null || this.iPage.diffTo(url).contains((Object)Url.UrlPart.BASE))) {
                this.iPage = url;
                this.iLastTitleForPage = null;
            }
        }

        public void navigationFinished(NavigationFinishedEvent navigationFinishedEvent) {
        }
    }

    private static class StatusTextListenerAdapter
    implements StatusListener {
        private final StatusTextListener iStatusTextListener;

        private StatusTextListenerAdapter(StatusTextListener statusTextListener) {
            this.iStatusTextListener = statusTextListener;
        }

        public void statusChanged(StatusChangedEvent statusChangedEvent) {
            String string = statusChangedEvent.getStatusText();
            if (string != null && EncodingUtils.needsDecoding(string)) {
                string = EncodingUtils.decodeUrl(string);
            }
            this.iStatusTextListener.statusChanged(new StatusTextChangedEvent(string));
        }
    }
}

