/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser;

import com.mathworks.html.CustomProtocolUrl;
import com.mathworks.html.FileUrl;
import com.mathworks.html.HtmlDataListener;
import com.mathworks.html.HtmlFileWriter;
import com.mathworks.html.HtmlPanel;
import com.mathworks.html.Url;
import com.mathworks.html.UrlVisitor;
import com.mathworks.html.WebUrl;
import com.mathworks.html.jxbrowser.CommonBrowserRunnable;
import com.mathworks.html.jxbrowser.JxBrowserPanel;
import com.mathworks.html.jxbrowser.PrintStrategy;
import com.teamdev.jxbrowser.Browser;
import java.awt.Desktop;
import java.io.File;

public class DesktopPrintStrategy
implements PrintStrategy {
    private final boolean fPrintOnlinePages;
    private File fPrintFile;

    DesktopPrintStrategy(boolean bl) {
        this.fPrintOnlinePages = bl;
    }

    @Override
    public void print(JxBrowserPanel jxBrowserPanel, HtmlDataListener<Boolean> htmlDataListener) {
        Url url = jxBrowserPanel.getNavigator().getCurrentLocation();
        if (url != null) {
            PrintUrlResolver printUrlResolver = new PrintUrlResolver(jxBrowserPanel, htmlDataListener);
            url.accept(printUrlResolver);
        } else {
            htmlDataListener.dataRetrieved(false);
        }
    }

    @Override
    public void dispose() {
        if (this.fPrintFile != null) {
            this.fPrintFile.delete();
        }
    }

    private class PrintUrlResolver
    implements UrlVisitor {
        private final JxBrowserPanel iPanel;
        private final HtmlDataListener<Boolean> iSuccessListener;

        private PrintUrlResolver(JxBrowserPanel jxBrowserPanel, HtmlDataListener<Boolean> htmlDataListener) {
            this.iPanel = jxBrowserPanel;
            this.iSuccessListener = htmlDataListener;
        }

        @Override
        public void visitFileUrl(FileUrl fileUrl) {
            try {
                this.printFile(fileUrl.getFile());
                this.iSuccessListener.dataRetrieved(true);
            }
            catch (Exception exception) {
                this.iSuccessListener.dataRetrieved(false);
            }
        }

        @Override
        public void visitWebUrl(final WebUrl webUrl) {
            if (DesktopPrintStrategy.this.fPrintOnlinePages) {
                CommonBrowserRunnable commonBrowserRunnable = new CommonBrowserRunnable(){

                    @Override
                    public void handleBrowser(Browser browser) {
                        boolean bl = PrintUrlResolver.this.printWebUrlOnBrowserThread(browser, webUrl);
                        PrintUrlResolver.this.iSuccessListener.dataRetrieved(bl);
                    }
                };
                this.iPanel.getBrowser().invokeLater(commonBrowserRunnable);
            }
        }

        private boolean printWebUrlOnBrowserThread(Browser browser, WebUrl webUrl) {
            String string = browser.getContent();
            File file = this.getPrintFile();
            HtmlFileWriter htmlFileWriter = new HtmlFileWriter(file, string, webUrl.toString(), false);
            htmlFileWriter.saveFile();
            if (file.exists()) {
                try {
                    this.printFile(file);
                    return true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }

        @Override
        public void visitCustomProtocolUrl(CustomProtocolUrl customProtocolUrl) {
            this.iSuccessListener.dataRetrieved(false);
        }

        private File getPrintFile() {
            File file = HtmlPanel.getResourceDirectory();
            File file2 = new File(file, "browserprint.html");
            if (DesktopPrintStrategy.this.fPrintFile != null && !DesktopPrintStrategy.this.fPrintFile.equals(file2)) {
                DesktopPrintStrategy.this.fPrintFile.delete();
            }
            DesktopPrintStrategy.this.fPrintFile = file2;
            return file2;
        }

        private void printFile(File file) throws Exception {
            Desktop.getDesktop().print(file);
        }
    }
}

