/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser;

import com.jniwrapper.win32.ie.KeyFilter;
import com.mathworks.html.BrowserQueue;
import com.mathworks.html.jxbrowser.JxBrowserKeyAdapter;
import com.mathworks.html.jxbrowser.JxBrowserSwingComponent;
import com.teamdev.jxbrowser.ie.IEBrowser;
import java.awt.event.KeyEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

class IEConfig {
    private static final Set<Integer> TO_SUPPRESS_WITH_CONTROL = new HashSet<Integer>();
    private final JxBrowserSwingComponent fComponent;

    IEConfig(JxBrowserSwingComponent jxBrowserSwingComponent) {
        this.fComponent = jxBrowserSwingComponent;
    }

    void configureBrowser(IEBrowser iEBrowser) {
        assert (BrowserQueue.isBrowserThread()) : "We should only access the browser on the browser thread.";
        JxBrowserKeyAdapter jxBrowserKeyAdapter = new JxBrowserKeyAdapter(this.fComponent);
        iEBrowser.getPeer().setKeyFilter((KeyFilter)new IEBrowserKeyFilter(jxBrowserKeyAdapter));
    }

    private static KeySuppressOption getKeySuppressOption(KeyFilter.KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 18) {
            return KeySuppressOption.SUPPRESS_IE_BEHAVIOR;
        }
        if (keyEvent.isControlPressed() && IEConfig.isSuppressedWithControlDown(keyEvent.getKeyCode())) {
            return KeySuppressOption.SUPPRESS_IE_BEHAVIOR;
        }
        return KeySuppressOption.ALLOW;
    }

    private static boolean isSuppressedWithControlDown(int n) {
        return TO_SUPPRESS_WITH_CONTROL.contains(n);
    }

    static {
        TO_SUPPRESS_WITH_CONTROL.add(70);
        TO_SUPPRESS_WITH_CONTROL.add(80);
        TO_SUPPRESS_WITH_CONTROL.add(79);
        TO_SUPPRESS_WITH_CONTROL.add(67);
    }

    private static class KeyEventProcessor
    implements Runnable {
        private final JxBrowserSwingComponent iComponent;
        private final JxBrowserKeyAdapter iListener;
        private final KeyFilter.KeyEvent iKeyEvent;

        private KeyEventProcessor(JxBrowserSwingComponent jxBrowserSwingComponent, JxBrowserKeyAdapter jxBrowserKeyAdapter, KeyFilter.KeyEvent keyEvent) {
            this.iComponent = jxBrowserSwingComponent;
            this.iListener = jxBrowserKeyAdapter;
            this.iKeyEvent = keyEvent;
        }

        @Override
        public void run() {
            int n = this.getModifiers();
            KeyStroke keyStroke = KeyStroke.getKeyStroke(this.iKeyEvent.getKeyCode(), n);
            KeyEvent keyEvent = new KeyEvent(this.iComponent, 401, System.currentTimeMillis(), n, keyStroke.getKeyCode(), keyStroke.getKeyChar());
            this.iListener.cloneAndProcessEvent(keyEvent);
        }

        private int getModifiers() {
            int n = 0;
            if (this.iKeyEvent.isAltPressed()) {
                n |= 0x200;
            }
            if (this.iKeyEvent.isControlPressed()) {
                n |= 0x80;
            }
            if (this.iKeyEvent.isShiftPressed()) {
                n |= 0x40;
            }
            return n;
        }
    }

    private class IEBrowserKeyFilter
    implements KeyFilter {
        private final JxBrowserKeyAdapter iListener;

        private IEBrowserKeyFilter(JxBrowserKeyAdapter jxBrowserKeyAdapter) {
            this.iListener = jxBrowserKeyAdapter;
        }

        public boolean isFilter(KeyFilter.KeyEvent keyEvent) {
            KeySuppressOption keySuppressOption = IEConfig.getKeySuppressOption(keyEvent);
            switch (keySuppressOption) {
                case SUPPRESS_FULLY: {
                    return true;
                }
                case SUPPRESS_IE_BEHAVIOR: {
                    SwingUtilities.invokeLater(new KeyEventProcessor(IEConfig.this.fComponent, this.iListener, keyEvent));
                    return true;
                }
                case ALLOW: {
                    return false;
                }
            }
            return false;
        }
    }

    private static enum KeySuppressOption {
        SUPPRESS_FULLY,
        SUPPRESS_IE_BEHAVIOR,
        ALLOW;

    }
}

