/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser;

import com.mathworks.html.FindOption;
import com.mathworks.html.HtmlDataListener;
import com.mathworks.html.HtmlFindInPage;
import com.mathworks.html.jxbrowser.JxBrowserPanel;
import java.util.Collection;

public class IEFindInPage
implements HtmlFindInPage {
    private final JxBrowserPanel fPanel;
    private static final String FIND_FUNCTION = "function(text, direction, flags, textRegexp, collapseOption, wraparoundFlag) {\n    var range = document.selection.createRange();\n    if (range.text.match(textRegexp)) {\n        range.collapse(collapseOption);\n    } else {\n        range = document.body.createTextRange();\n    }\n    var found = range.findText(text, direction, flags);\n    if (!found && !wraparoundFlag) {\nreturn false;\n    }\n    for (var i = 0; i < 20 && found; i++) {\n        try {\n            range.select();\n            range.scrollIntoView();\n            return true;\n        } catch (e) {\n            range.collapse(collapseOption);\n            found = range.findText(text, direction, flags);\n        }\n    }\n    document.selection.empty();\n    return false;\n}";

    IEFindInPage(JxBrowserPanel jxBrowserPanel) {
        this.fPanel = jxBrowserPanel;
    }

    @Override
    public void find(String string, Collection<FindOption> collection, HtmlDataListener<Boolean> htmlDataListener) {
        boolean bl = collection.contains((Object)FindOption.SEARCH_BACKWARDS);
        boolean bl2 = collection.contains((Object)FindOption.WRAP_AROUND);
        int n = bl ? -1 : 1;
        int n2 = IEFindInPage.getFindOptions(collection);
        String string2 = "'" + string.replaceAll("([\\(\\)\\'\\/\\\\])", "\\\\$1") + "'," + n + "," + n2 + "," + IEFindInPage.toJavaScriptRegexp(string) + "," + bl + "," + bl2;
        String string3 = "(function(text, direction, flags, textRegexp, collapseOption, wraparoundFlag) {\n    var range = document.selection.createRange();\n    if (range.text.match(textRegexp)) {\n        range.collapse(collapseOption);\n    } else {\n        range = document.body.createTextRange();\n    }\n    var found = range.findText(text, direction, flags);\n    if (!found && !wraparoundFlag) {\nreturn false;\n    }\n    for (var i = 0; i < 20 && found; i++) {\n        try {\n            range.select();\n            range.scrollIntoView();\n            return true;\n        } catch (e) {\n            range.collapse(collapseOption);\n            found = range.findText(text, direction, flags);\n        }\n    }\n    document.selection.empty();\n    return false;\n})(" + string2 + ");";
        FindSuccessListener findSuccessListener = htmlDataListener == null ? null : new FindSuccessListener(htmlDataListener);
        this.fPanel.executeScript(string3, findSuccessListener);
    }

    private static String toJavaScriptRegexp(String string) {
        return "/" + string.replaceAll("([\\.\\*\\+\\?\\|\\(\\)\\[\\]\\s+\\/\\\\])", "\\\\$1") + "/i";
    }

    private static int getFindOptions(Collection<FindOption> collection) {
        int n = 0;
        for (FindOption findOption : collection) {
            n |= IEFindInPage.getFlagForOption(findOption);
        }
        return n;
    }

    private static int getFlagForOption(FindOption findOption) {
        switch (findOption) {
            case MATCH_CASE: {
                return 4;
            }
            case WHOLE_WORDS: {
                return 2;
            }
        }
        return 0;
    }

    private static class FindSuccessListener
    implements HtmlDataListener<String> {
        private final HtmlDataListener<Boolean> iRealListener;

        private FindSuccessListener(HtmlDataListener<Boolean> htmlDataListener) {
            this.iRealListener = htmlDataListener;
        }

        @Override
        public void dataRetrieved(String string) {
            this.iRealListener.dataRetrieved(string.equals("true"));
        }
    }
}

