/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser;

import com.mathworks.html.jxbrowser.JxBrowserSettings;
import com.teamdev.jxbrowser.prompt.CloseStatus;
import com.teamdev.jxbrowser.prompt.DialogParams;
import com.teamdev.jxbrowser.prompt.LoginParams;
import com.teamdev.jxbrowser.prompt.PromptDialogParams;
import com.teamdev.jxbrowser.prompt.PromptService;
import com.teamdev.jxbrowser.prompt.ScriptErrorParams;

class MWPromptService
implements PromptService {
    private final JavaScriptHandler fJavaScriptHandler;
    private final PromptService fBaseService;

    MWPromptService(PromptService promptService) {
        this.fBaseService = promptService;
        this.fJavaScriptHandler = MWPromptService.getJavaScriptHandler();
    }

    private static JavaScriptHandler getJavaScriptHandler() {
        String string = JxBrowserSettings.getProperty("JxBrowser.JavaScriptErrors");
        try {
            return string == null ? JavaScriptHandler.SUPPRESS : JavaScriptHandler.valueOf(string);
        }
        catch (Exception exception) {
            return JavaScriptHandler.SUPPRESS;
        }
    }

    public void alertRequested(DialogParams dialogParams) {
        this.fBaseService.alertRequested(dialogParams);
    }

    public CloseStatus promptRequested(PromptDialogParams promptDialogParams) {
        return this.fBaseService.promptRequested(promptDialogParams);
    }

    public CloseStatus confirmationRequested(DialogParams dialogParams) {
        return this.fBaseService.confirmationRequested(dialogParams);
    }

    public CloseStatus loginRequested(LoginParams loginParams) {
        return this.fBaseService.loginRequested(loginParams);
    }

    public CloseStatus badCertificateRequested(DialogParams dialogParams) {
        return this.fBaseService.badCertificateRequested(dialogParams);
    }

    public CloseStatus scriptErrorRequested(ScriptErrorParams scriptErrorParams) {
        switch (this.fJavaScriptHandler) {
            case ALERT: {
                return this.fBaseService.scriptErrorRequested(scriptErrorParams);
            }
            case CONSOLE: {
                System.out.println("JavaScript error");
                System.out.println("\tFile:    " + scriptErrorParams.getSourceFile());
                System.out.println("\tLine:    " + scriptErrorParams.getLineNumber());
                System.out.println("\tMessage: " + scriptErrorParams.getMessage());
            }
        }
        return CloseStatus.YES;
    }

    static enum JavaScriptHandler {
        SUPPRESS,
        ALERT,
        CONSOLE;

    }
}

