/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser;

import com.mathworks.html.CustomProtocolUrl;
import com.mathworks.html.FileUrl;
import com.mathworks.html.HtmlDataListener;
import com.mathworks.html.PageChangedEvent;
import com.mathworks.html.PageChangedListener;
import com.mathworks.html.StreamingTextUrlManager;
import com.mathworks.html.Url;
import com.mathworks.html.jxbrowser.BrowserHolder;
import com.mathworks.html.jxbrowser.CommonBrowserCallable;
import com.teamdev.jxbrowser.Browser;
import com.teamdev.jxbrowser.events.NavigationAdapter;
import com.teamdev.jxbrowser.events.NavigationFinishedEvent;
import java.io.File;
import javax.swing.SwingUtilities;

public class NavigationFinishedListener
extends NavigationAdapter {
    private final BrowserHolder fBrowser;
    private final StreamingTextUrlManager fUrlManager;
    private final PageChangedListener fListener;
    private Url fLastUrl = null;

    public NavigationFinishedListener(BrowserHolder browserHolder, StreamingTextUrlManager streamingTextUrlManager, PageChangedListener pageChangedListener) {
        this.fBrowser = browserHolder;
        this.fUrlManager = streamingTextUrlManager;
        this.fListener = pageChangedListener;
    }

    public void navigationFinished(NavigationFinishedEvent navigationFinishedEvent) {
        Object object;
        Url url = Url.parseSilently(navigationFinishedEvent.getUrl());
        if (url != null && url.getType() == Url.UrlType.WEB && navigationFinishedEvent.isNavigationFailed()) {
            return;
        }
        int n = this.getStreamingTextIndexFromUrl(url);
        if (n >= 0) {
            url = new CustomProtocolUrl("text", String.valueOf(n));
        }
        if (url != null && url.getType() == Url.UrlType.FILE) {
            assert (url instanceof FileUrl);
            object = ((FileUrl)url).getFile();
            if (((File)object).getName().endsWith(".txt")) {
                String string = ((File)object).getName();
                this.sendPageChange(string, url, this.getLastUrl());
                return;
            }
        }
        object = new TitleCallable();
        TitleListener titleListener = new TitleListener(url, this.getLastUrl());
        this.setLastUrl(url);
        this.fBrowser.invokeLaterAndNotify(object, titleListener, "");
    }

    private void sendPageChange(final String string, final Url url, final Url url2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NavigationFinishedListener.this.fListener.pageChanged(new PageChangedEvent(string, url, url2));
            }
        });
    }

    private int getStreamingTextIndexFromUrl(String string) {
        Url url = Url.parseSilently(string);
        return url == null ? -1 : this.getStreamingTextIndexFromUrl(url);
    }

    private int getStreamingTextIndexFromUrl(Url url) {
        return this.fUrlManager.getIndexFromUrl(url);
    }

    private synchronized void setLastUrl(Url url) {
        this.fLastUrl = url;
    }

    private synchronized Url getLastUrl() {
        return this.fLastUrl;
    }

    private class TitleListener
    implements HtmlDataListener<String> {
        private final Url iNewUrl;
        private final Url iOldUrl;

        private TitleListener(Url url, Url url2) {
            this.iNewUrl = url;
            this.iOldUrl = url2;
        }

        @Override
        public void dataRetrieved(String string) {
            if (string == null || string.length() == 0 || NavigationFinishedListener.this.getStreamingTextIndexFromUrl(string) >= 0) {
                string = this.iNewUrl.toString();
            }
            NavigationFinishedListener.this.sendPageChange(string, this.iNewUrl, this.iOldUrl);
        }
    }

    private static class TitleCallable
    extends CommonBrowserCallable<String> {
        private TitleCallable() {
        }

        @Override
        public String handleBrowser(Browser browser) {
            return browser.getTitle();
        }
    }
}

