/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser;

import com.mathworks.html.BrowserQueue;
import com.mathworks.html.HtmlDataListener;
import com.mathworks.html.jxbrowser.BrowserAccessCallable;
import com.mathworks.html.jxbrowser.BrowserAccessRunnable;
import com.mathworks.html.jxbrowser.BrowserHolder;
import com.mathworks.html.jxbrowser.BrowserTypeCallable;
import com.mathworks.html.jxbrowser.BrowserTypeRunnable;
import com.teamdev.jxbrowser.Browser;
import com.teamdev.jxbrowser.ie.IEBrowser;
import com.teamdev.jxbrowser.mozilla.MozillaBrowser;
import com.teamdev.jxbrowser.safari.SafariBrowser;
import java.awt.Component;
import java.util.concurrent.Callable;

public class QueuingBrowserHolder
implements BrowserHolder {
    private final BrowserHolder.Type fType;
    private final Dispatcher<? extends Browser> fDispatcher;
    private final Browser fBrowser;
    private boolean fDisposed = false;

    public QueuingBrowserHolder(Browser browser) {
        this.fType = BrowserHolder.Type.fromBrowserType(browser.getType());
        this.fDispatcher = this.createDispatcher(this.fType, browser);
        this.fBrowser = browser;
    }

    protected QueuingBrowserHolder(BrowserHolder.Type type, Browser browser, Dispatcher<Browser> dispatcher) {
        this.fType = type;
        this.fBrowser = browser;
        this.fDispatcher = dispatcher;
    }

    @Override
    public BrowserHolder.Type getType() {
        return this.fType;
    }

    @Override
    public Component getComponent() {
        return this.fBrowser.getComponent();
    }

    @Override
    public void disposeBrowser(Runnable runnable, boolean bl) {
        this.markDisposed();
        final DisposeRunnable disposeRunnable = new DisposeRunnable(runnable);
        if (bl) {
            BrowserQueue.invokeAndWait(disposeRunnable);
        } else {
            BrowserQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Thread thread = new Thread(disposeRunnable, "JxBrowser disposer");
                    thread.setDaemon(true);
                    thread.start();
                }
            });
        }
    }

    private synchronized void markDisposed() {
        this.fDisposed = true;
    }

    @Override
    public synchronized boolean isDisposed() {
        return this.fDisposed;
    }

    private Dispatcher<? extends Browser> createDispatcher(BrowserHolder.Type type, Browser browser) {
        switch (type) {
            case Mozilla: {
                return new MozillaDispatcher((MozillaBrowser)browser);
            }
            case Mozilla15: {
                return new Mozilla15Dispatcher((com.teamdev.jxbrowser.mozilla15.MozillaBrowser)browser);
            }
            case IE: {
                return new IEDispatcher((IEBrowser)browser);
            }
            case Safari: {
                return new SafariDispatcher((SafariBrowser)browser);
            }
        }
        throw new IllegalArgumentException("Browser type " + browser.getType() + " is not supported.");
    }

    @Override
    public final void invokeNow(BrowserTypeRunnable browserTypeRunnable) {
        this.fDispatcher.invoke(browserTypeRunnable);
    }

    @Override
    public final <T> T invokeNow(BrowserTypeCallable<T> browserTypeCallable) {
        return this.fDispatcher.invoke(browserTypeCallable, null);
    }

    @Override
    public final void invokeLater(BrowserAccessRunnable browserAccessRunnable) {
        BrowserQueue.invokeLater(new BrowserRunnableAdapter(browserAccessRunnable));
    }

    @Override
    public final <V> void invokeLaterAndNotify(BrowserAccessCallable<V> browserAccessCallable, HtmlDataListener<V> htmlDataListener, V v) {
        BrowserQueue.invokeLaterAndNotify(new BrowserCallableAdapter(browserAccessCallable, v), htmlDataListener);
    }

    @Override
    public final void invokeAndWait(BrowserAccessRunnable browserAccessRunnable) {
        BrowserQueue.invokeAndWait(new BrowserRunnableAdapter(browserAccessRunnable));
    }

    @Override
    public final <V> V invokeAndReturn(BrowserAccessCallable<V> browserAccessCallable, V v) {
        try {
            return BrowserQueue.invokeAndReturn(new BrowserCallableAdapter(browserAccessCallable, v));
        }
        catch (Exception exception) {
            return v;
        }
    }

    private class SafariDispatcher
    extends Dispatcher<SafariBrowser> {
        private SafariDispatcher(SafariBrowser safariBrowser) {
            super(QueuingBrowserHolder.this, (Browser)safariBrowser);
        }

        @Override
        void doInvoke(BrowserAccessRunnable browserAccessRunnable) {
            browserAccessRunnable.handleSafariBrowser((SafariBrowser)this.getBrowser());
        }

        @Override
        <V> V doInvoke(BrowserAccessCallable<V> browserAccessCallable) {
            return browserAccessCallable.handleSafariBrowser((SafariBrowser)this.getBrowser());
        }
    }

    private class Mozilla15Dispatcher
    extends Dispatcher<com.teamdev.jxbrowser.mozilla15.MozillaBrowser> {
        private Mozilla15Dispatcher(com.teamdev.jxbrowser.mozilla15.MozillaBrowser mozillaBrowser) {
            super(QueuingBrowserHolder.this, (Browser)mozillaBrowser);
        }

        @Override
        void doInvoke(BrowserAccessRunnable browserAccessRunnable) {
            browserAccessRunnable.handleMozilla15Browser((com.teamdev.jxbrowser.mozilla15.MozillaBrowser)this.getBrowser());
        }

        @Override
        <V> V doInvoke(BrowserAccessCallable<V> browserAccessCallable) {
            return browserAccessCallable.handleMozilla15Browser((com.teamdev.jxbrowser.mozilla15.MozillaBrowser)this.getBrowser());
        }
    }

    private class MozillaDispatcher
    extends Dispatcher<MozillaBrowser> {
        private MozillaDispatcher(MozillaBrowser mozillaBrowser) {
            super(QueuingBrowserHolder.this, (Browser)mozillaBrowser);
        }

        @Override
        void doInvoke(BrowserAccessRunnable browserAccessRunnable) {
            browserAccessRunnable.handleMozillaBrowser((MozillaBrowser)this.getBrowser());
        }

        @Override
        <V> V doInvoke(BrowserAccessCallable<V> browserAccessCallable) {
            return browserAccessCallable.handleMozillaBrowser((MozillaBrowser)this.getBrowser());
        }
    }

    private class IEDispatcher
    extends Dispatcher<IEBrowser> {
        private IEDispatcher(IEBrowser iEBrowser) {
            super(QueuingBrowserHolder.this, (Browser)iEBrowser);
        }

        @Override
        void doInvoke(BrowserAccessRunnable browserAccessRunnable) {
            browserAccessRunnable.handleIEBrowser((IEBrowser)this.getBrowser());
        }

        @Override
        <V> V doInvoke(BrowserAccessCallable<V> browserAccessCallable) {
            return browserAccessCallable.handleIEBrowser((IEBrowser)this.getBrowser());
        }
    }

    private class BrowserRunnableAdapter
    implements Runnable {
        private BrowserAccessRunnable iRunnable;

        private BrowserRunnableAdapter(BrowserAccessRunnable browserAccessRunnable) {
            this.iRunnable = browserAccessRunnable;
        }

        @Override
        public void run() {
            QueuingBrowserHolder.this.fDispatcher.invoke(this.iRunnable);
        }
    }

    private class BrowserCallableAdapter<V>
    implements Callable<V> {
        private final BrowserAccessCallable<V> iCallable;
        private final V iIfDisposed;

        private BrowserCallableAdapter(BrowserAccessCallable<V> browserAccessCallable, V v) {
            this.iCallable = browserAccessCallable;
            this.iIfDisposed = v;
        }

        @Override
        public V call() throws Exception {
            return QueuingBrowserHolder.this.fDispatcher.invoke(this.iCallable, this.iIfDisposed);
        }
    }

    private static abstract class Dispatcher<T extends Browser> {
        private final T iBrowser;
        final /* synthetic */ QueuingBrowserHolder this$0;

        private Dispatcher(T t) {
            this.this$0 = var1_1;
            this.iBrowser = t;
        }

        protected final T getBrowser() {
            return this.iBrowser;
        }

        final void invoke(BrowserAccessRunnable browserAccessRunnable) {
            if (!this.this$0.isDisposed()) {
                this.doInvoke(browserAccessRunnable);
            }
        }

        final <V> V invoke(BrowserAccessCallable<V> browserAccessCallable, V v) {
            if (!this.this$0.isDisposed()) {
                return this.doInvoke(browserAccessCallable);
            }
            return v;
        }

        abstract void doInvoke(BrowserAccessRunnable var1);

        abstract <V> V doInvoke(BrowserAccessCallable<V> var1);
    }

    private class DisposeRunnable
    implements Runnable {
        private final Runnable iPostDisposeRunnable;

        private DisposeRunnable(Runnable runnable) {
            this.iPostDisposeRunnable = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (!QueuingBrowserHolder.this.fBrowser.isDisposed()) {
                    QueuingBrowserHolder.this.fBrowser.stop();
                    QueuingBrowserHolder.this.fBrowser.waitReady();
                    QueuingBrowserHolder.this.fBrowser.dispose();
                }
            }
            catch (Throwable throwable) {
            }
            finally {
                this.iPostDisposeRunnable.run();
            }
        }
    }
}

