/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser;

import com.mathworks.html.BrowserRequest;
import com.mathworks.html.BrowserRequestManager;
import com.mathworks.html.RequestHandler;
import com.mathworks.html.Url;
import com.teamdev.jxbrowser.WebPolicyDelegate;
import com.teamdev.jxbrowser.events.NavigationEvent;
import com.teamdev.jxbrowser.events.NavigationFinishedEvent;
import com.teamdev.jxbrowser.events.NavigationListener;

public class RequestHandlerPolicyDelegate
implements WebPolicyDelegate,
NavigationListener {
    private final RequestHandler fRequestHandler;
    private final BrowserRequestManager fRequestManager = new BrowserRequestManager();

    public RequestHandlerPolicyDelegate(RequestHandler requestHandler) {
        this.fRequestHandler = requestHandler;
    }

    public void setPendingRequest(Url url, BrowserRequest.Origin origin) {
        this.fRequestManager.setPendingRequest(url, origin);
    }

    public Url getPendingUrl() {
        return this.fRequestManager.getPendingUrl();
    }

    public BrowserRequest.Origin getPendingOrigin() {
        return this.fRequestManager.getPendingOrigin();
    }

    public boolean allowNavigation(NavigationEvent navigationEvent) {
        Url url = RequestHandlerPolicyDelegate.getUrlForNavigationEvent(navigationEvent);
        BrowserRequest browserRequest = this.fRequestManager.getRequestForUrl(url);
        if (browserRequest == null) {
            return true;
        }
        boolean bl = this.fRequestHandler.handleRequest(browserRequest);
        return !bl;
    }

    public boolean allowMimeType(String string, NavigationEvent navigationEvent) {
        return true;
    }

    public void navigationStarted(NavigationEvent navigationEvent) {
    }

    public void navigationFinished(NavigationFinishedEvent navigationFinishedEvent) {
        Url url = RequestHandlerPolicyDelegate.getUrlForNavigationEvent((NavigationEvent)navigationFinishedEvent);
        this.fRequestManager.requestCompleted(url);
    }

    private static Url getUrlForNavigationEvent(NavigationEvent navigationEvent) {
        String string = navigationEvent.getUrl();
        return string == null ? null : Url.parseSilently(string);
    }
}

