/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser.chromium;

import com.teamdev.jxbrowser.chromium.Browser;
import com.teamdev.jxbrowser.chromium.events.FinishLoadingEvent;
import com.teamdev.jxbrowser.chromium.events.LoadAdapter;
import com.teamdev.jxbrowser.chromium.events.LoadListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

class JxBrowserChromiumComponent
extends JPanel {
    private final JComponent fBrowserComponent;
    private boolean fReady = false;

    JxBrowserChromiumComponent(final Browser browser) {
        this.fBrowserComponent = browser.getView().getComponent();
        browser.addLoadListener((LoadListener)new LoadAdapter(){

            public void onFinishLoadingFrame(FinishLoadingEvent finishLoadingEvent) {
                JxBrowserChromiumComponent.this.markReady();
                browser.removeLoadListener((LoadListener)this);
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.fBrowserComponent, "Center");
    }

    private void markReady() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JxBrowserChromiumComponent.this.fReady = true;
                JxBrowserChromiumComponent.this.repaint();
                if (JxBrowserChromiumComponent.this.isFocusOwner()) {
                    JxBrowserChromiumComponent.this.fBrowserComponent.requestFocus();
                }
            }
        });
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.fReady) {
            super.paint(graphics);
        } else {
            Dimension dimension = this.getSize();
            graphics.clearRect(0, 0, dimension.width, dimension.height);
        }
    }

    @Override
    public void requestFocus() {
        if (this.fReady) {
            this.fBrowserComponent.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    @Override
    public boolean requestFocus(boolean bl) {
        if (this.fReady) {
            return this.fBrowserComponent.requestFocus(bl);
        }
        return super.requestFocus(bl);
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.fReady) {
            return this.fBrowserComponent.requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }

    @Override
    public synchronized void addFocusListener(FocusListener focusListener) {
        this.fBrowserComponent.addFocusListener(focusListener);
    }

    @Override
    public synchronized void removeFocusListener(FocusListener focusListener) {
        this.fBrowserComponent.removeFocusListener(focusListener);
    }

    @Override
    public synchronized FocusListener[] getFocusListeners() {
        return this.fBrowserComponent.getFocusListeners();
    }
}

